'.----------+----------+--------- [Latest X] -------+---------------------:
'|                        LatestX System v1.11 by TuS                     |
':----------+----------+----------+-----------------+---------------------:

'**************************************************************************
'* Copyright (C) 2011                                                     *
'* TuS, tustus[at]hotmail[dot]com                                         *
'*                                                                        *
'* This program is free software; you can redistribute it and/or modify   *
'* it under the terms of the GNU General Public License as published by   *
'* the Free Software Foundation; either version 2 of the License, or      *
'* (at your option) any later version.                                    *
'*                                                                        *
'* This program is distributed in the hope that it will be useful, but    *
'* WITHOUT ANY WARRANTY; without even the implied warranty of             *
'* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                   *
'* See the GNU General Public License for more details.                   *
'*                                                                        *
'* You should have received a copy of the GNU General Public License      *
'* along with this program; if not, write to the                          *
'* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,    *
'* MA 02111-1307 USA                                                      *
'**************************************************************************
'**************************************************************************
'* VBS Script logging Framework :                                         *
'* Copyright (C) 2006                                                     *
'* Christer Finsen, mind[underscore]trip[at]users[dot]sourceforge[dot]net *
'* Nils-Erik Aurker, nils-erik[at]users[dot]sourceforge[dot]net          *
'**************************************************************************

Option Explicit

'Import Configuration
Import ("latestx.config")

'Make sure constants in latestx.config are correctlly defined
If TypeName(RAIDENFTPD_PATH) <> "String" _
	Or TypeName(LATEST_FOLDER) <> "String" _
	Or TypeName(LATEST_VFS_MAX) <> "Integer" _
	Or TypeName(SECTIONS_ENABLED) <> "Boolean" _
	Or TypeName(SECTIONS_LEVEL) <> "Integer" _
	Or TypeName(SECTIONS_SEPARATOR) <> "String" _
	Or TypeName(DETAILPATH_ENABLED) <> "Boolean" _
	Or TypeName(DETAILPATH_LEVEL) <> "Integer" _
	Or TypeName(DETAILPATH_SEPARATOR) <> "String" _
	Or TypeName(LATEST_IGNORELIST) <> "String" _
	Or TypeName(LATEST_VFS_IGNORELIST) <> "String" _
	Or TypeName(EVENTLOG) <> "Integer" _
	Or TypeName(FILELOG) <> "Integer" _
	Or TypeName(NUMBEROFLOGS) <> "Integer" Then
	WScript.echo "One or more required constants is not defined. Please see " _
	& "readme.txt for installation"
	WScript.quit
End If

'*********************************************************************************
'                        CUSTOMIZABLE CONSTANTS
'*********************************************************************************
' See Latestx.Config
'*********************************************************************************
'       DO NOT CHANGE THESE CONSTANTS UNLESS YOU KNOW WHAT YOU ARE DOING
'*********************************************************************************
Const APPNAME       = "TuS LatestX"
Const APPVERMAJOR   = "1"
Const APPVERMINOR   = "11"
Const AUTHOR        = "TuS"
Const COPYYEAR      = "2011"
Const FORREADING    = 1
Const FORWRITING    = 2
Const FORAPPENDING  = 8
Const SUCCESS       = 0
Const ERRORL        = 1
Const WARNING       = 2
Const INFORMATION   = 4
Const ABORT         = "Script aborted with error(s). To determine cause, see logged information"
'Script Root folder
Dim SCRIPTPATH : SCRIPTPATH = Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName,"\")-1)
'*********************************************************************************
'012345678901234567890123456789012345678901234567890123456789012345678901234567891

'#################################################################################
'	Main Entry Point
'#################################################################################
Dim iCnt, cCollection, element, ret, sSection, sDetailPath
Dim cmdSERVER, cmdEVENT,cmdOption, cmdGCID, cmdRELEASE, cmdRELEASEPATH, cmdVIRTUALPATH, cmdVIRTUALFolder, cmdType
Dim aJunctions, aJunction
Dim oArgs : Set oArgs = WScript.Arguments
Dim currentSub : currentSub = "Main Code"
Dim tStartTime,tEndTime

Const DEBUG_CLASS_EVENTS = False
Const FIRE_CLASS_EVENTS  = False

tStartTime = Timer()

'#-------------------------------------------------------------------------------#
'Load the framwork
'#-------------------------------------------------------------------------------#
'Init the Logger
Dim UserLog : Set UserLog = New UserLogClass
UserLog.LogEvent SUCCESS, "*** " & APPNAME & " " & APPVERMAJOR & "." & APPVERMINOR & " by " & AUTHOR & " ***"
UserLog.LogEvent SUCCESS, APPNAME & " Ver." & APPVERMAJOR & "." & APPVERMINOR & " Copyright(C) " & COPYYEAR
UserLog.LogEvent SUCCESS, APPNAME & " Ver." & APPVERMAJOR & "." & APPVERMINOR & " comes with ABSOLUTELY NO WARRANTY;"
UserLog.LogEvent SUCCESS, "This is free software, and you are welcome to redistribute it under certain" 
UserLog.LogEvent SUCCESS, "conditions; Read License.txt for details." 
UserLog.LogEvent SUCCESS, "VBS Script logging Framework: Copyright (C) 2006 Christer Finsen,and Nils-Erik Aurker" 
UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
UserLog.LogEvent SUCCESS, "[Main Code] Script Started"
'Init the Helper
Dim Helper : Set Helper = New HelperClass

'start the logger
UserLog.Start
'#-------------------------------------------------------------------------------#
'Init the FTPD VFS File 
Dim RaidenVFSFile : Set RaidenVFSFile = New RaidenVFSFileClass

'Init the FTPD Output File
Dim RaidenOutFile : Set RaidenOutFile = New RaidenOutFileClass

'Init the Junction Class
Dim Junction : Set Junction = New JunctionClass
Junction.Path = SCRIPTPATH & "\Tools\Junction.exe"

'Simple verification that the FTPD process is initiating the command in a way we expect
If oArgs.Count < 2 Then
	UserLog.LogEvent ERRORL, "[" & currentSub & "] FTPD or this installation has been tampered with. This command needs at least FIVE arguments to run"
	WScript.Quit
End If

'Assign Main Parameters
For iCnt = 0 To oArgs.Count -1 
	UserLog.LogEvent INFORMATION, "[" & currentSub & "] Argument#" & iCnt+1 & ", Value=" & oArgs(iCnt)
	
	Select Case iCnt
		Case 0
			cmdGCID = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] GCID=" & cmdGCID
		Case 1
			cmdSERVER = oArgs(iCnt)
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] SERVER=" & cmdSERVER
		Case 2
			cmdEVENT = UCase(oArgs(iCnt))
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] EVENT=" & cmdEVENT
		Case 3
			If cmdEVENT = "LATESTX" Then 'it's a user command
				cmdType   = "User"
				cmdOption = UCase(oArgs(iCnt))
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Option=" & cmdOption
			Else
				cmdType   = "Event"
				cmdRELEASE = Helper.CleanString(Right(oArgs(iCnt), Len(oArgs(iCnt)) - InStrRev(oArgs(iCnt),"\")))
				cmdRELEASEPATH = Left(oArgs(iCnt), InStrRev(oArgs(iCnt),"\") -1)
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] RELEASE=" & cmdRELEASE
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] RELEASEPATH=" & cmdRELEASEPATH
			End If
		Case 4
			If cmdEVENT = "LATESTX" Then 'it's a user command
				'NA
			Else
				cmdVIRTUALPATH = Helper.CleanString(Left(oArgs(iCnt), InStrRev(oArgs(iCnt),"/")-1))
				If cmdVIRTUALPATH = vbNullString Then 'it Is FTPDroot folder
					cmdVIRTUALPATH = vbNullString
				    UserLog.LogEvent INFORMATION, "[" & currentSub & "] VIRTUALPATH=" & cmdVIRTUALPATH
				    cmdVIRTUALFolder = "Root"
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] cmdVIRTUALFolder=" & cmdVIRTUALFolder 
				Else
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] VIRTUALPATH=" & cmdVIRTUALPATH
					cmdVIRTUALFolder = Replace(mid(cmdVIRTUALPATH, 2, Len(cmdVIRTUALPATH)-1), "/", "-")
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] cmdVIRTUALFolder=" & cmdVIRTUALFolder
				End If 
			End if
	End Select
Next	

' Assign Class Properties (This is the working Context)
'#-------------------------------------------------------------------------------#
RaidenVFSFile.Server		= cmdSERVER
RaidenVFSFile.Path			= RAIDENFTPD_PATH

RaidenOutFile.GCID 			= cmdGCID
RaidenOutFile.Server		= cmdSERVER
RaidenOutFile.Path			= RAIDENFTPD_PATH
RaidenOutFile.SceneView 	= SCENEVIEW
RaidenOutFile.Width			= WIDTH
'#-------------------------------------------------------------------------------#

'Now we are ready to Process
UserLog.LogEvent SUCCESS, "[Main Code] Processing " & cmdEVENT & " " & cmdOption & " " & cmdVIRTUALPATH & "/" & cmdRELEASE
'Check the VFS ignore list
If (Helper.ValidateVFS(cmdVIRTUALPATH,split(LATEST_VFS_IGNORELIST,"|")) = False) Or (cmdType = "User") then	
	'Check the directory ignore list
	If (Helper.Validate(cmdRELEASE,split(LATEST_IGNORELIST,"|")) = False) Or (cmdType = "User")then
	
		'load the user File
		RaidenVFSFile.Load
	
		If RaidenVFSFile.Loaded = True Then
			'User generated Commands
			Select Case (cmdEVENT)
				Case "LATESTX"
					Select Case cmdOption
					    Case "CLEAR"
					    	ret = Junction.DeleteJunctionMask(LATEST_FOLDER,"*")
					    Case "REPAIR"
					    	ret = Junction.DeleteBrokenJunctions(LATEST_FOLDER)
						Case Else
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] HELP Command Process Started"
							
							RaidenOutFile.WriteMsgHeader
							RaidenOutFile.WriteMsg "Syntax: site latestx <command>",1
							RaidenOutFile.WriteMsgSeperator
							RaidenOutFile.WriteMsg "Commands:",1
							
							RaidenOutFile.WriteMsg "repair : Check existing LatestX entries (delete broken)",4
							RaidenOutFile.WriteMsg "clear  : Clear all LatestX entries (reset)",4
							RaidenOutFile.WriteMsgWithAppend "", "(Config: " & LATEST_VFS_MAX & " folders)" ,1
							RaidenOutFile.WriteMsgTail
							
							UserLog.LogEvent SUCCESS, "[" & currentSub & "] HELP Command Process Completed"	
					End Select		
					'terminate
					UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
					UserLog.DelLog
					WScript.Quit
			End Select
			
			If (SECTIONS_ENABLED) then
				'Get the Section
				sSection = "[" & UCase(RaidenVFSFile.GetSectionFromPath (cmdVIRTUALPATH, SECTIONS_LEVEL))& "]" & SECTIONS_SEPARATOR
			End If	
			
			'Additional path info
			If (DETAILPATH_ENABLED) Then
				If cmdVIRTUALPATH <> vbNullString then
					sDetailPath = Mid(cmdVIRTUALPATH,2,Len(cmdVIRTUALPATH)-1)
					If InStr(sDetailPath,"/") > 0 Then
						For iCnt=1 To DETAILPATH_LEVEL-1
							sDetailPath = right(sDetailPath, Len(sDetailPath)-InStr(sDetailPath,"/"))
						Next
						If (Len(sDetailPath) > 0) Then
							sDetailPath = "[" & Replace(sDetailPath,"/","#") & "]" & DETAILPATH_SEPARATOR
						End If
					Else
						sDetailPath = vbNullString 
					End If 
				Else
					sDetailPath = vbNullString
				End If 
			End If
			
			'FTPD generated Commands
			Select Case (cmdEVENT)
				Case "NEWDIR"	
					'Check and create the ReleaseDir folder in the LATEST_FOLDER
					ret = Junction.CreateJunction(LATEST_FOLDER, sSection & sDetailPath & cmdRELEASE, cmdRELEASEPATH & "\" & cmdRELEASE)
					'Keep only the limited latest Junctions
					'Helper.KeepOnly  LATEST_FOLDER,LATEST_VFS_MAX,2 	
					If Helper.FileExists(SCRIPTPATH & "\Tools\KeepNewest.exe", False) then
						ret = Helper.ShellRun(Chr(34) & SCRIPTPATH & "\Tools\KeepNewest.exe" & Chr(34) & " " & Chr(34) & LATEST_FOLDER & Chr(34) & " " & LATEST_VFS_MAX & " junction >> KeepNewest.log",0,False)
					End if
				Case "DELDIR"
					'Check and delete the ReleaseDir Junction in the LATEST_FOLDER
					ret = Junction.DeleteJunction(LATEST_FOLDER, sSection & sDetailPath & cmdRELEASE)
					
				Case "MOVEDIR"
						'## TODO ##
						'Missing event / Params from FTPD
				
				Case "NUKEDIR"
					aJunctions = Junction.GetJunctionList(LATEST_FOLDER, cmdRELEASEPATH & "\" & Replace(cmdRELEASE,"[NUKED]",vbNullString) & "*")
					For Each element In aJunctions
						aJunction = Split(element,"|")
						
						'Check and delete the ReleaseDir Junction in the LATEST_FOLDER
						ret = Junction.DeleteJunction(LATEST_FOLDER,aJunction(1))
						
						'Check and create the ReleaseDir folder in the LATEST_FOLDER
						ret = Junction.CreateJunction(LATEST_FOLDER, Replace(aJunction(1),Replace(cmdRELEASE,"[NUKED]",vbNullString),cmdRELEASE), Replace(aJunction(2),Replace(cmdRELEASE,"[NUKED]",vbNullString),cmdRELEASE))
					Next 
				Case "UNNUKEDIR"
					aJunctions = Junction.GetJunctionList(LATEST_FOLDER, cmdRELEASEPATH & "\" & "[NUKED]" & cmdRELEASE & "*")
					For Each element In aJunctions
						aJunction = Split(element,"|")
						
						'Check and delete the ReleaseDir Junction in the LATEST_FOLDER
						ret = Junction.DeleteJunction(LATEST_FOLDER, aJunction(1))
						
						'Check and create the ReleaseDir folder in the LATEST_FOLDER
						ret = Junction.CreateJunction(LATEST_FOLDER, Replace(aJunction(1),"[NUKED]" & cmdRELEASE, cmdRELEASE ), Replace(aJunction(2),"[NUKED]" & cmdRELEASE, cmdRELEASE))
					Next 
					'Check and delete the ReleaseDir Junction in the LATEST_FOLDER
					ret = Junction.DeleteJunction(LATEST_FOLDER, sSection & sDetailPath & "[NUKED]" & cmdRELEASE)
					'Check and create the ReleaseDir folder in the LATEST_FOLDER
					ret = Junction.CreateJunction(LATEST_FOLDER, sSection & sDetailPath & cmdRELEASE, cmdRELEASEPATH & "\" & cmdRELEASE)
			End select
		End If
	Else 
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] [" & cmdRELEASE & "] was IGNORED (DIR Ignore list)."
	End If
Else
	UserLog.LogEvent SUCCESS, "[" & currentSub & "] [" & cmdVIRTUALPATH & "] was IGNORED (VFS Ignore list).."
End if
UserLog.LogEvent SUCCESS, "[Main Code] Script Completed"
UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
UserLog.DelLog
'#################################################################################
'	Main Exit Point
'#################################################################################

'#################################################################################
' Class Wrapper for Array Management
'#################################################################################
Class ArrayWrapper
	'Class vars
	Private  c_aArray(), c_iClassItems, c_sClassType, c_sClassName, c_oParent
	'Local vars
	Private bFound, iCnt, iSize, iGetSize, iLoopValue, sValue, element, aNewArray
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize()
		c_sClassName	= "ArrayWrapper"
		c_iClassItems 	= 0
		c_sClassType  	= vbNullString
		Set c_oParent	= Nothing
	End Sub
	Private Sub Class_Terminate()
		'Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	'Class Properties
	Public Property Get Size()
		If IsArray(c_aArray) Then
			Size = c_iClassItems
		End If
	End Property
	Public Property Get oType()
		If IsArray(c_aArray) Then
			oType = c_sClassType
		End If
	End Property
	Public Property Let oType(strType)
		c_sClassType = strType
	End Property
	Public Property Get Data()
		Data = c_aArray
	End Property
	Public Property Get Parent()
		Set Parent = c_oParent
	End Property
	Public Property Let Parent(oParent)
		Set c_oParent = oParent
	End Property
	'#---------------------------------------------------------------------------#
	
	Public Function GetIndexByValue(sStringToTest)
		'**********************************************************************************
		' Purpose : This function loops the array and returns the index depending on weither
		'           or not a string exists as one of the values within the array. 
		' Inputs	: string	: sStringToTest	: string	: the string to check
		' Return	: integer	: the index in the array if found / -1 If Not found
		'****************************************************************************
		'Init vars
		iLoopValue 	= 0
		GetIndexByValue 	= -1
		
		If c_iClassItems > 0 Then
			For Each element In c_aArray
				If IsArray(element) Then
					sValue = element(0)
				Else
					sValue = element
				End If
				
				'cast to string
				sValue = sValue & vbNullString
				sStringToTest = sStringToTest & vbNullString
				
				If LCase(sStringToTest) = LCase(sValue) Then
					GetIndexByValue = iLoopValue + 1
					Exit Function
				End If
				iLoopValue = iLoopValue + 1
			Next
		End If
	End Function
	
	Public Function AddItem(sElement)
		'**********************************************************************************
		' Purpose : This function will Add the specified element to the array
		' Inputs	: string	: sElement	: the string element to add
		' Return	: integer	: OK = True / Error = false
		'**********************************************************************************
		On Error Resume Next
		
		'Detect the not initialized array
		If c_iClassItems = 0 Then
			ReDim c_aArray(0)
			c_aArray(0) = sElement
		Else
			ReDim Preserve c_aArray(c_iClassItems)
			c_aArray(c_iClassItems) = sElement
		End If
		
		c_iClassItems = c_iClassItems + 1
		
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
			AddItem = False
		Else 
			AddItem = True
		End If
		
		'Fire an event
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType, "AddItem", AddItem, sElement
			End If
		End If 
	End Function
	
	Public Function Clear()
		'**********************************************************************************
		' Purpose : This function will Reset the array
		' Inputs	: none
		'**********************************************************************************
		Erase c_aArray 
		c_iClassItems = 0
		
		'Detect Error
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
			Clear = False
		Else 
			Clear = True
		End If
		'clear the error state
		Err.Clear
		
		'Fire an event
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType, "Clear", Clear, vbNullString
			End If
		End If 
	End Function
	
	Public Function UpdateItem(index,sElement)
		'**********************************************************************************
		' Purpose 	: This function will Update the specified element to the array
		' Inputs	: integer 	: index 	: the index to edit
		'			  string	: sElement	: the string element to add
		' Return	: integer	: OK = True / Error = false
		'**********************************************************************************
		'init vars
		UpdateItem = False
		
		'Detect the not initialized array
		If c_iClassItems = 0 Then
			UpdateItem = False
		ElseIf ((index <= (c_iClassItems)) And (index > 0)) Then
			c_aArray(index-1) = sElement
			UpdateItem = True
		End If
		
		'Fire an event
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType,"UpdateItem", UpdateItem, index & ":" & Join(sElement,"|")
			End If
		End If 
	End Function
	
	Public Function DeleteItemByIndex(iElementIndex)
		'**********************************************************************************
		' Purpose 	: This function will delete the specified element from the array
		' Inputs	: integer	: iElementIndex	: the index of the element to delete
		'**********************************************************************************
		'init vars
		aNewArray 			= Empty
		sValue				= Empty
		bFound 				= False
		DeleteItemByIndex 	= False
		iLoopValue 			= 1
		
		iSize = GetSize(c_aArray)
		
		If ((iElementIndex <= (iSize)) And (iElementIndex > 0))Then 
			'extract the array data
			For Each element In c_aArray
				If iLoopValue <> iElementIndex Then
					iSize = GetSize(aNewArray)
					If iSize = 0 Then
						ReDim aNewArray(0) : aNewArray(0) = element 
					Else
						ReDim Preserve aNewArray(iSize) : aNewArray(iSize) = element
					End If
				Else 
					bFound = True
				End If
				iLoopValue = iLoopValue + 1
			Next
			
			'write the data
			If (bFound = True) Then
				iSize = GetSize(aNewArray)
				If (iSize >= 1) Then
					'Set the new values
					ReDim c_aArray(iSize-1)
					
					iLoopValue  = 0
					For Each element In aNewArray
						c_aArray(iLoopValue) = element
						iLoopValue = iLoopValue + 1
					Next
					c_iClassItems = iSize
				Else
					Erase c_aArray
					c_iClassItems = 0
				End If
				DeleteItemByIndex = True
			End If
		End If 
		
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
		End If 
		
		'clear the error state
		Err.Clear
		
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType,"DeleteIndex", DeleteItemByIndex, iElementIndex
			End If
		End If 
	End Function
	
	Public Function DeleteItemByValue(Value,index)
		'**********************************************************************************
		' Purpose : This function will delete the specified element from the array
		' Inputs	: string	: Value	: the string Item to delete
		'			  integer	: index	: the index of array to check	
		' Return	: integer	: OK = True / Error = false
		
		'**********************************************************************************
		'set the default output
		aNewArray 			= Empty
		sValue				= Empty
		bFound 				= False
		DeleteItemByValue 	= False
		iLoopValue 			= 0
		
		'Find the element
		For Each element In c_aArray
			If IsArray(element) Then
				sValue = element(index)
			Else
				sValue = element
			End If	
			
			'cast to string
			sValue 	= sValue & vbNullString
			Value 	= Value & vbNullString	
			
			If LCase(sValue) <> LCase(Value) Then
				iSize = GetSize(aNewArray)
				If iSize = 0 Then
					ReDim aNewArray(0) : aNewArray(0) = element 
				Else
					ReDim Preserve aNewArray(iSize) : aNewArray(iSize) = element
				End If
			Else 
				bfound = True
			End If
		Next
		
		' write the data
		If (bfound = True) Then
			iSize = GetSize(aNewArray)
			If (iSize >= 1) Then
				'Set the new values
				ReDim c_aArray(iSize-1)
				
				iLoopValue = 0
				For Each element In aNewArray
					c_aArray(iLoopValue) = element
					iLoopValue = iLoopValue + 1
				Next
				c_iClassItems = iSize
			Else
				Erase c_aArray
				c_iClassItems = 0
			End If 
			DeleteItemByValue = True
		End If 
		
		If Err.Number <> 0 Then
			WScript.echo Err.Number & " : " & Err.Description
			Err.Clear
		End If 
		
		If (TypeName(FIRE_CLASS_EVENTS) <> "Nothing") Then
			If (FIRE_CLASS_EVENTS = True) Then
				Class_FireEvent "ArrayWrapper:" & c_sClassType,"DeleteItem", DeleteItemByValue, Value
			End If 
		End If 
	End Function
	
	Public Function GetItemByIndex(iElementIndex)
		'**********************************************************************************
		' Purpose : This function will return the specified element from the array
		' Inputs	: integer	: iElementIndex	: the index of the element search for
		'**********************************************************************************
		'init vars
		GetItemByIndex = Empty
		
		If ((iElementIndex <= (c_iClassItems)) And (iElementIndex > 0)) Then
			GetItemByIndex = c_aArray(iElementIndex-1)
		End If
	End Function
	
	Public Function GetItemByValue(ElementValue)
		'**********************************************************************************
		' Purpose : This function will return the specified element from the array
		' Inputs	: integer	: ElementValue	: the value of the element to search for
		'**********************************************************************************
		GetItemByValue = Empty
		
		For Each element In c_aArray
			If IsArray(element) Then
				sValue = element(0)
			Else
				sValue = element
			End If	
			
			'cast to string
			sValue = sValue & vbNullString
			ElementValue = ElementValue & vbNullString	
			
			If (LCase(sValue) = LCase(ElementValue)) Then
				GetItemByValue = element
				Exit Function	
			End If
		Next
	End Function
	
	Private Function GetSize(aArray)
		'#--------------------------------------------------------------------------------#
		' Purpose : Check the array size
		'#--------------------------------------------------------------------------------#	
		On Error Resume Next
		iGetSize = UBound(aArray)
		
		If Err.Number Then
			If ((Err.Number = 9) Or(Err.Number = 13)) Then
				iGetSize = 0
			End If
		Else
			iGetSize = UBound(aArray) + 1
		End If
		On Error Goto 0
		GetSize = iGetSize
	End Function 
	
	Private Function Class_FireEvent (sSource, sEventType, bResult, aValues)
		'#--------------------------------------------------------------------------------#
		' Purpose : Fire an event
		'#--------------------------------------------------------------------------------#	
		If TypeName(c_oParent) <> "Nothing" Then 
			c_oParent.Class_Event sSource, sEventType, bResult, aValues
		End If 
	End Function
End Class

'#################################################################################
' Class Wrapper for Junction Management
'#################################################################################
Class JunctionClass
	'Class vars
	Private	c_sPath,c_bLoaded
	'Function vars
	Public aOutput, str, aOutputelement, iCnt, iCnt2, arrList, iGetSize, sProcessTime
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		c_sPath		 	= vbNullString 
		c_bLoaded		= False
	End Sub
	Private Sub Class_Terminate
		
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get Path()
		Path = c_sPath
	End Property
	Public Property Let Path(sPath)
		If sPath <> vbNullString Then
			c_sPath = sPath
			c_bLoaded = ValidateConfig()
		End If 
	End Property
	Public Property Get Loaded()
		Loaded = c_bLoaded
	End Property
	Private Property Let Loaded(bLoaded)
		If (VarType(bLoaded) = vbBoolean) Then
			c_bLoaded = bLoaded
		End If 
	End Property
	'#---------------------------------------------------------------------------#
	
	Function CheckJunction(sPath, sTarget)
		'********************************************************************************
		' Puropose : Check if is the Target is a NTFS Junction
		' Input    : sPath   : string : The path to Junction
		'		   : sTarget : string : The Target to check
		' Output   : integer : -1 : Error processing Command or sTarget Not Found
		'                    :  0 : sTarget Found but NOT a Junction Point
		'                    :  1 : sTarget Found and IS a valid Junction point
		'					 :  2 : sTarget Found But Is NOT a valid Junction point
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:CheckJunction"
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & Chr(34) & sTarget & Chr(34) & " -------------- Started."
		
		If (c_bLoaded) Then
			'Run the command
			aOutput = Helper.ShellRun(Chr(34) & c_sPath & Chr(34) & " " & Chr(34) & sPath & "\" & sTarget & Chr(34),0,true)
			
			'Just for output debug
			For Each aOutputelement In aOutput
   				 UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & aOutputelement
   			Next
						
			'Process output
			If UBound(aOutput) >= 7 Then
				Select Case aOutput(5)
					Case "No matching files were found."
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Target Not Found."
						CheckJunction = -1
				
					Case "No reparse points found."
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Target Found but NOT a Junction Point."
						CheckJunction = 0
					
					Case sPath & "\" & sTarget & ": JUNCTION"
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] " &Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Target Found and IS a Junction point." & aOutput(6)
						'Validate the target Path
						str = Right(aOutput(6),Len(aOutput(6))-20)

						If (Helper.FolderExists(str,False)) Then
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] " &Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Substitute Name : is Valid " & str 
							CheckJunction = 1
						Else 
							UserLog.LogEvent INFORMATION, "[" & currentSub & "] " &Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Substitute Name : Inexistant target " & str
							CheckJunction = 2
						End If 
					Case Else
						UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Target Not Found"
						CheckJunction = -1
				End Select

			Else
				'Default to error
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Error processing Command or Target Not Found."
				CheckJunction = -1
			End If
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " --------------  Complete."	
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] " & "Junction Configuration Problem"	
		End If 
	End Function 

	Function CreateJunction(sPath, sTarget, sSource)
		'********************************************************************************
		' Puropose : Create a  Junction Point
		' Input    : sPath   : string : The Destination path
		'		   : sTarget : string : The Destination Target
		' 	         sSource : string : The Source path
		' Output   : integer : False : Error processing Command or sTarget Not Found
		'                    : True  : sTarget Junction point Deleted Successfully
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:CreateJunction"
	
		If (c_bLoaded) Then
			'Check if sTarget is a valid Junction point
			If (CheckJunction(sPath, sTarget) = -1) Then
				
				'Validate the destination folder
				If Helper.FolderExists(sSource, False) then
					'Run the command
					aOutput = Helper.ShellRun(Chr(34) & c_sPath & Chr(34) & " " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " " & Chr(34) & sSource & Chr(34),0,true)
					
					'Just for output debug
					'For Each aOutputelement In aOutput
		   			'	 UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & aOutputelement
		   			'Next
					
					'Process output
					If UBound(aOutput) >= 6 Then
						Select Case aOutput(5)
							Case "Created: " & sPath & "\" & sTarget
								UserLog.LogEvent SUCCESS, "[" & currentSub & "] " &Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Junction point Created. " & aOutput(6) 
								CreateJunction = True
							Case Else
								UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Target Allready exists. ABORT"
								CreateJunction = False
						End Select
					Else
						'Default to error
						CreateJunction = False
					End If
				Else
					UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sSource & Chr(34) & " Source does not exist. Abort"	
					CreateJunction = False
				End if
			Else
				UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " Target Allready exists. ABORT"	
				CreateJunction = False
			End if
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] " & "Junction Configuration Problem"	
		End If
	End Function 	

	Function DeleteBrokenJunctions(sPath)
		'********************************************************************************
		' Puropose : Delete all broken Junction Point
		' Input    : sPath : string : The path
		' Output   : integer : False : Error processing Command or sTarget Not Found for one of the targets
		'                    :  True : all sTarget Junction Points were Deleted
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:DeleteBrokenJunctions"
		
		If (c_bLoaded) Then
			'list Folders
			arrList = Helper.GetFolderContent(sPath, true, "*")
			
			On Error Resume Next
			iGetSize = UBound(arrList)
		
			If Err.Number Then
				If ((Err.Number = 9) Or(Err.Number = 13)) Then
					iGetSize = 0
				End If
			Else
				iGetSize = UBound(arrList) + 1
			End If
			On Error Goto 0
			
			'init the counter
			iCnt = 0
			iCnt2 = 0
			RaidenOutFile.WriteMsgHeader
			
			If (iGetSize = 0) then
				RaidenOutFile.WriteMsg "No links to Check...",1
				RaidenOutFile.WriteMsgTail
				UserLog.LogEvent SUCCESS, "[" & currentSub & "] " &Chr(34) & sPath & "\" & element & Chr(34) & " : No Junction point to Check."
				Exit Function
			Else
				RaidenOutFile.WriteMsg "Checking " & iGetSize & " links...",1
			End IF
			RaidenOutFile.WriteMsgSeperator 		
			For Each element In arrList
				'inc the counter
				iCnt2 = iCnt2 + 1
				'Check if sTarget is a broken Junction point
				If (CheckJunction(sPath, element) = 2) Then
					'Run the command
					aOutput = Helper.ShellRun(Chr(34) & c_sPath & Chr(34) & " -d " & Chr(34) & sPath & "\" & element & Chr(34),0,true)
					
					'Just for output debug
					For Each aOutputelement In aOutput
		   				 UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & aOutputelement
		   			Next
					
					'Process output
					If UBound(aOutput) >= 6 Then
						Select Case aOutput(5)
							Case "Deleted " & sPath & "\" & element & "."
								UserLog.LogEvent INFORMATION, "[" & currentSub & "] " &Chr(34) & sPath & "\" & element & Chr(34) & " : Junction point Deleted."
								'inc the delete counter
								iCnt = iCnt + 1
								RaidenOutFile.WriteMsgWithAppend Helper.BuildStringNumber(iCnt2, Len(LATEST_VFS_MAX),"0",")")  & element ,": Deleted",1
								If (DeleteBrokenJunctions <> False )Then
									DeleteBrokenJunctions = True
								End if
							Case Else
								UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sPath & "\" & element & Chr(34) & " : Target Not Found"
								DeleteBrokenJunctions = False
						End Select
					Else
						'Default to error
						DeleteBrokenJunctions = False
					End If
				Else
					UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & Chr(34) & sPath & "\" & element & Chr(34) & " is a valid Junction."
					RaidenOutFile.WriteMsgWithAppend Helper.BuildStringNumber(iCnt2, Len(LATEST_VFS_MAX),"0",")") & element ,": OK",1	
					If (DeleteBrokenJunctions <> False )Then
							DeleteBrokenJunctions = true
					End if
				End If
			Next
			
			tEndTime = Timer()
			sProcessTime = ((tEndTime - tStartTime)*1000)
			
			If iCnt = 0 Then
				RaidenOutFile.WriteMsgWithAppend "","No links were deleted ["& sProcessTime &"ms]",2
			Else
				RaidenOutFile.WriteMsgWithAppend "",iCnt & " link(s) deleted ["& sProcessTime &"ms]",2	
			End If
			RaidenOutFile.WriteMsgTail
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] " & "Junction Configuration Problem"			
			RaidenOutFile.PostMessage "Error","Unable to process Command. please check Log Files",2
		End If

	End Function 

	Function DeleteJunction(sPath,sTarget)
		'********************************************************************************
		' Puropose : Delete an existant Junction Point
		' Input    : sPath : string : The path
		'		   : sTarget : string : The Target to delete
		' Output   : integer : False : Error processing Command or sTarget Not Found
		'                    :  True : sTarget Junction point Deleted Successfully
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:DeleteJunction"
		
		If (c_bLoaded) Then
			
			'Check if sTarget is a valid Junction point
			'ret = CheckJunction(sPath, sTarget)
			
			'Removed junction check (no need to check just delete) 
			ret = 1
			
			If ((ret = 1) Or (ret = 2)) Then
				'Run the command
				aOutput = Helper.ShellRun(Chr(34) & c_sPath & Chr(34) & " -d " & Chr(34) & sPath & "\" & sTarget & Chr(34),0,true)
				
				'Just for output debug
				For Each aOutputelement In aOutput
		   			 UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & aOutputelement
		   		Next
				
				'Process output
				If UBound(aOutput) >= 6 Then
					Select Case aOutput(5)
						Case "Deleted " & sPath & "\" & sTarget & "."
							UserLog.LogEvent SUCCESS, "[" & currentSub & "] " &Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Junction point Deleted."
							DeleteJunction = True
						Case Else
							UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " : Target Not Found"
							DeleteJunction = False
					End Select
				Else
					'Default to error
					DeleteJunction = False
				End If
			Else
				UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sPath & "\" & sTarget & Chr(34) & " Target Not Found."	
				DeleteJunction = False
			End if
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] " & "Junction Configuration Problem"	
		End If

	End Function 

	Function DeleteJunctionMask(sPath,sMask)
		'********************************************************************************
		' Puropose : Delete an existant Junction Point
		' Input    : sPath : string : The path
		'		   : sMask : string : The Target Mask to match
		' Output   : integer : False : Error processing Command or sTarget Not Found for one of the targets
		'                    :  True : all sTarget Junction Points were Deleted
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:DeleteJunctionMask"
		
		If (c_bLoaded) Then
			'list Folders
			arrList = Helper.GetFolderContent(sPath, true, "*")
			
			On Error Resume Next
			iGetSize = UBound(arrList)
		
			If Err.Number Then
				If ((Err.Number = 9) Or(Err.Number = 13)) Then
					iGetSize = 0
				End If
			Else
				iGetSize = UBound(arrList) + 1
			End If
			On Error Goto 0

			'init the counter
			iCnt = 0
			iCnt2 = 0
			RaidenOutFile.WriteMsgHeader
			If (iGetSize = 0) then
				RaidenOutFile.WriteMsg "No links to delete...",1
				RaidenOutFile.WriteMsgTail
				UserLog.LogEvent SUCCESS, "[" & currentSub & "] " &Chr(34) & sPath & "\" & element & Chr(34) & " : No Junction point to delete."
				Exit Function
			Else
				RaidenOutFile.WriteMsg "Deleting " & iGetSize & " links...",1
			End IF
			RaidenOutFile.WriteMsgSeperator 		
			
			For Each element In arrList
				'inc the counter
				iCnt2 = iCnt2 + 1
				'Check if sTarget is a valid Junction point
				If ((CheckJunction(sPath, element) = 1) Or (CheckJunction(sPath, element)=2)) Then
					'Run the command
					aOutput = Helper.ShellRun(Chr(34) & c_sPath & Chr(34) & " -d " & Chr(34) & sPath & "\" & element & Chr(34),0,true)
				
					'Just for output debug
					For Each aOutputelement In aOutput
		   				 UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & aOutputelement
		   			Next
		   			
					'Process output
					If UBound(aOutput) >= 6 Then
						Select Case aOutput(5)
							Case "Deleted " & sPath & "\" & element & "."
								UserLog.LogEvent SUCCESS, "[" & currentSub & "] " &Chr(34) & sPath & "\" & element & Chr(34) & " : Junction point Deleted."
								
								'inc the delete counter
								iCnt = iCnt + 1
								RaidenOutFile.WriteMsgWithAppend Helper.BuildStringNumber(iCnt2, Len(LATEST_VFS_MAX),"0",")") & element ,": Deleted",1
								
								If (DeleteJunctionMask <> False )Then
									DeleteJunctionMask = True 
								End if
							Case Else
								UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sPath & "\" & element & Chr(34) & " : Target Not Found"
								DeleteJunctionMask = False
						End Select
					Else
						'Default to error
						DeleteJunctionMask = False
					End If
				Else
					UserLog.LogEvent ERRORL, "[" & currentSub & "] " & Chr(34) & sPath & "\" & element & Chr(34) & " Target Not Found."	
					DeleteJunctionMask = False
				End If
			Next
			
			tEndTime = Timer()
			sProcessTime = ((tEndTime - tStartTime)*1000)
			
			'Write the output
			If iCnt = 0 Then
				RaidenOutFile.WriteMsgWithAppend "","No links were deleted ["& sProcessTime &"ms]",2
			Else
				RaidenOutFile.WriteMsgWithAppend "",iCnt & " link(s) deleted ["& sProcessTime &"ms]",2	
			End If
			RaidenOutFile.WriteMsgTail
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] " & "Junction Configuration Problem"	
			RaidenOutFile.PostMessage "Error","Unable to process Command. please check Log Files",2
		End If
		
	End Function 		

	Function GetJunctionList(sPath, sMask)
		'********************************************************************************
		' Puropose : Check if is the Target is a NTFS Junction
		' Input    : sPath   : string : The path to Junction
		'		   : sTarget : string : The Target to check
		' Output   : integer : -1 : Error processing Command or sTarget Not Found
		'                    :  0 : sTarget Found but NOT a Junction Point
		'                    :  1 : sTarget Found and IS a valid Junction point
		'					 :  2 : sTarget Found But Is NOT a valid Junction point
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:GetJunctionList"
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & Chr(34) & sPath & Chr(34) & " -------------- Started."
		
		Dim junctionNameFull
		Dim junctionName
		Dim junctionLinkFull
		Dim aJunctions()
		Dim matchCnt
		Dim sTmpJuncLine
		
		If (c_bLoaded) Then
			'Run the command (list all junctions)
			aOutput = Helper.ShellRun(Chr(34) & c_sPath & Chr(34) & " -s " & Chr(34) & sPath & Chr(34),0,true)
			
			matchCnt = -1
			'Process the output
			For iCnt=5 To UBound(aOutput)-1
			
				sTmpJuncLine = aOutput(iCnt)
				
				'Bug in junction.exe output (adds one or several "." and some 'CR' (Carriage Return) at the begening of the line randomly??
				iPos = InStr(sTmpJuncLine,"\\?\")
				If iPos > 1 Then
					sTmpJuncLine = Right(sTmpJuncLine, Len(sTmpJuncLine) - iPos +1)
				End If 
	
				If (InStr(sTmpJuncLine,"\\?\")) Then
	   				 'UserLog.LogEvent INFORMATION, "[" & currentSub & "] " & aOutput(iCnt)
	   				 If Left(sTmpJuncLine(iCnt),4) = "\\?\" Then
	   				 	junctionNameFull = Mid(sTmpJuncLine(iCnt),5,Len(sTmpJuncLine(iCnt))-14)
	   				 	junctionName = Replace(junctionNameFull,sPath & "\",vbNullString)
	   				 	junctionLinkFull = Mid(aOutput(iCnt+1),21,Len(aOutput(iCnt+1))-20)
	   				 	If Helper.FileMatchesPattern(junctionLinkFull,sMask) Then
	   				 		matchCnt = matchCnt + 1
	   				 		ReDim Preserve aJunctions(matchCnt)
	   				 		aJunctions(matchCnt) = junctionNameFull & "|" & junctionName & "|" & junctionLinkFull
	   				 		UserLog.LogEvent INFORMATION, "[" & currentSub & "] MATCH: " & junctionNameFull & "|" & junctionName & "|" & junctionLinkFull
	   				 	Else
	   				 		UserLog.LogEvent INFORMATION, "[" & currentSub & "] " &junctionNameFull & "|" & junctionName & "|" & junctionLinkFull
	   				 	End If
	  				 End If
	  			End if
   			Next
   			
   			GetJunctionList = aJunctions
   		Else
   			GetJunctionList = Array()
   		End if 
	End Function 	

	Function ValidateConfig()
		'********************************************************************************
		' Puropose : Validate the Utility Configuration
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class Junction:ValidateConfig()"
		
		'check that junction executable exists
		ValidateConfig = Helper.FileExists(Junction.Path, True)
	End Function 
End Class

'#################################################################################
' Class Wrapper for RaidenFTPD VFS File
'#################################################################################
Class RaidenVFSFileClass
	'Class vars
	Public	c_sServer,c_sPath, c_sFile, c_bLoaded, c_iCount, c_sFTPDRoot
	Public oFso,oFile
	'Function vars
	Public VFS, item, iCount
	Public aData, aVFSInfo, sLine, ret, aArray
	Public sData, element
	Public	bFileExists, bFound
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		c_bLoaded		= False
		c_iCount    	= 0
		c_sPath		 	= vbNullString 
		c_sFile			= vbNullString
		c_sFTPDRoot		= vbNullString
		oFile			= Null
		Set VFS			= New ArrayWrapper
		VFS.oType		= "VFS"
		VFS.Parent		= me
		Set oFso		= CreateObject("Scripting.FileSystemObject")
	End Sub
	Private Sub Class_Terminate
		Set VFS			= Nothing
		Set aData		= Nothing
		Set oFso		= Nothing
		Set oFile		= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get Server()
		Server = c_sServer
	End Property
	Public Property Let Server(sServer)
	If (VarType(sServer) = vbString) Then
		c_sServer = sServer
	End If 
	End Property
	Public Property Get Loaded()
		Loaded = c_bLoaded
	End Property
	Private Property Let Loaded(bLoaded)
	If (VarType(bLoaded) = vbBoolean) Then
		c_bLoaded = bLoaded
	End If 
	End Property
	Public Property Get Path()
		Path = c_sPath
	End Property
	Public Property Let Path(sPath)
		If sPath <> vbNullString Then
			c_sPath = sPath
		End If 
	End Property
	Public Property Get VFSFile()
		VFSFile = c_sFile
	End Property
	Public Property Get Count()
		Count = c_iCount
	End Property
	Public Property Get FTPDRoot()
		FTPDRoot = c_sFTPDRoot
	End Property
	'#---------------------------------------------------------------------------#
	
	Public Function Load()
		'**********************************************************************************
		' Puropose : load in memory the Raiden VFS File
		' Input    : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:Load"
		On Error Goto 0
		'Init vars
		c_sFile	= c_sPath & "\" & c_sServer & ".vfs"
		c_bLoaded 	= False
		bFileExists = False
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Load VFSFile: " & c_sFile & " Started."

		'check that file exists		
		bFileExists = Helper.FileExists(c_sFile, True)
		
		'Open The file
		Set oFile = oFso.OpenTextFile(c_sFile, FORREADING)
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to read File: " & c_sFile & ". The error was: " & Err.description & " (" & Err.number & ")"
			Helper.Terminate
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & c_sFile & " was successfully opened for read."
		End If
		
		'Read The File
		Do While Not oFile.AtEndOfStream
			sData = oFile.ReadALL
		Loop
		oFile.close
		
		If (Not IsEmpty(sData)) Then
			'split the records
			aData = Split(sData,vbCrLf)
			
			For Each sLine In (aData)
				aVFSInfo = Split(sLine,"|")
				If (IsArray(aVFSInfo) And (UBound(aVFSInfo) = 15) )Then
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Processing VFSLine: " & sLine
					'store VFS Data in the VFS Array
					VFS.AddItem(aVFSInfo) 
					
					'Check if this is the FTPD Root Directory
					If (aVFSInfo(1) = "/") Then
						c_sFTPDRoot = aVFSInfo(0)
					End If
				End If
				Helper.EchoErr Err, currentSub
			Next
			'Update the class vars
			c_iCount	= VFS.Size
			c_bLoaded 	= True
			
			Set aData = Nothing
			Set sData = Nothing
			sLine = vbNullString
		End If
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] VFSFile: " & c_sFile & " successfully read and loaded."
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] VFSFile: Loaded VFS Entries:" & c_iCount 
	End Function

	Public Function Save()
		'**********************************************************************************
		' Puropose : Save the VFS in memory to the Raiden VFS File
		' Input    : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:Save"	
		
		If 	(c_bLoaded 	= True) Then
				
			Set oFile = oFso.CreateTextFile(c_sFile, True)
			
			If Err.number <> 0 Then
				UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to create output: " & c_sFile & ". The error was : " & Err.description & " (" & Err.number & ")"
				Helper.Terminate
			Else
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & c_sFile & " was successfully created."
				
				'Dump the VFS Content to the file
				For Each element In VFS.Data
					'//TODO
					'//Validation
										
					'Write the line 
					sLine = join(element,"|")
					oFile.WriteLine sLine
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write VFS Line : " & sLine
				Next
				
				'Close the file
				oFile.Close
				
				If Err.number <> 0 Then
					UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to close output: " & c_sFile & ". The error was : " & Err.description & " (" & Err.number & ")"
					Helper.Terminate
				Else
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & c_sFile & " was successfully Closed."
				End If
				
				Set oFile = Nothing	
			End If
		End if
	End Function
	
	Public Function ReadItemByIndex(iIndex)
		'**********************************************************************************
		' Puropose : Read a line Raiden VFS File
		' Input    : iIndex : index of the line
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:ReadLine"
		
		If iIndex <= VFS.Size Then
			ReadItemByIndex = VFS.GetItemByIndex(iIndex)		
		Else
			ReadItemByIndex = vbNullString
		End If 
	End Function
	
	Public Function AddItem(sElement)
		'**********************************************************************************
		' Purpose 	: Add a VFS Entry
		' Inputs	: string	: sElement	: the string element to add
		' Return	: integer	: OK = True / Error = false
		'**********************************************************************************
		
		On Error Resume Next
		 If VFS.AddItem(sElement) = True Then
		 	AddItem = True
		 	'Update the class vars
			c_iCount	= VFS.Size
		Else 
			AddItem = False
		End If
	End Function
	
	Public Function DeleteItemByValue(sStringPath,index)
		'**********************************************************************************
		' Puropose : delete a line in the Raiden VFS File based on the path 
		' Input    : iIndex : index of the line
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:DeleteItemByValue"
		
		If sStringPath <> vbNullString Then
			DeleteItemByValue = VFS.DeleteItemByValue(sStringPath, index)		
		Else
			DeleteItemByValue = False
		End If 
		'Update the class vars
		c_iCount	= VFS.Size
		
	End Function
	
	Public Function Clean(sMask)
		'**********************************************************************************
		' Puropose : Clean the Raiden VFS File
		' Input    : sMask : the mask to match
		'**********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:Clean"
		If Count > 0 Then
			For iCount = 1 To Count
				item = RaidenVFSFile.ReadItemByIndex(iCount)
				If InStr(item(1), sMask) Then
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] : Found match " & Join(item,"|")
				End if
			Next
		End If 
	End function
	
	Public Function GetSectionFromPath (sVirtualPath, ISecLevel)
		'********************************************************************************
		' Purpose : Return The Section matching the  virtual dir/file name
		' Input   : String 	: sVirtualPath		: The sVirtualPath to check
		'         : Integer	: ISecLevel		    : The Level For Section
		' Return  : String	: the Section Name found or vbnullString if not found
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFile:GetSectionFromPath" 
		
		Dim sLine
		'Get the current user Groups
		If (RaidenVFSFile.Count > 0) Then
			For Each element In VFS.Data
									
				'Extract the Section Data
				sLine = element(1)
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking Section " & sLine
				
				'ret = InStr(LCase(sLine),"/" & LCase(LATEST_FOLDER) & "/")
				'ret = InStr(LCase(sVirtualPath), LCase(sLine))
				
				If (sLine = "/") Then
					'This is the Root so not a section
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Root Folder (Not a Section) " & sLine
				ElseIf (InStr(LCase(sLine),"/" & LCase(LATEST_FOLDER))) Then 
					'This is one of the Script VFS Entry so not a section
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Script VFS Entry (Not a Section) " & sLine
				ElseIf (InStr(LCase(sVirtualPath), LCase(sLine))) Then  
					'This should be a section
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] Processing VFS Entry (Possibly a Section) " & sLine
					'Extract the Section
					aArray = Split(sLine,"/")
					If (UBound(aArray) > ISecLevel -1) Then
						GetSectionFromPath = aArray(ISecLevel)
						UserLog.LogEvent SUCCESS, "[" & currentSub & "] Matched Section (level:" & ISecLevel & "): " & GetSectionFromPath
						Exit for
					Else
						'Ends here if no match found
						GetSectionFromPath = "DEFAULT"
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] No Match Found using default section (level:" & ISecLevel & "): " & GetSectionFromPath
					End If 
				Else
					'Ends here if no match found
					GetSectionFromPath = "DEFAULT"
					UserLog.LogEvent INFORMATION, "[" & currentSub & "] No Match Found using default section (level:" & ISecLevel & "): " & GetSectionFromPath	
				End If
			Next
		Else 
			 GetSectionFromPath = vbNullString
		End If
	End Function

	Public Sub Class_Event(sSource, sEventType, ByVal bResult,ByVal values)
		'********************************************************************************
		' Purpose : Fire an event received from the child objects
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenVFSFileClass:Class_Event"
		
		If IsArray(values) Then
			values = Join(values,"|")
		End If 
		
		If (TypeName(DEBUG_CLASS_EVENTS) <> "Nothing") Then
			If (DEBUG_CLASS_EVENTS = True) Then
				WScript.Echo "EVENT FIRED [" & currentSub & "] source: " & sSource & " ; EventType:" & sEventType & " ; Result:" & bResult & " ; values:" & values
			End If
		End If 
	End Sub
End Class

'#################################################################################
' Class Wrapper for Logging
'#################################################################################
Class UserLogClass
	Private bLoaded, bLogActive
	Private	sLogRoot,sLog
	Private oShell,oFso,oRegEx,oLog,oFldr,oFile
	Private iLogToKeep,iArr,iCnt,n,m,temp
	Private	aLog,aDate
	Private cFiles
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		iLogToKeep	= NUMBEROFLOGS
		bLoaded		= False
		bLogActive	= False
		sLogRoot 	= SCRIPTPATH & "\Log"
		Set oShell 	= WScript.CreateObject("Wscript.Shell")
		Set oFso	= CreateObject("Scripting.FileSystemObject")
	End Sub
	Private Sub Class_Terminate
		Dim currentSub : currentSub = "Class UserLog:Class_Terminate"
		
		'Clean up the logs
		'DelLog
		
		Set oFso	= Nothing
		Set oShell	= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get LogPath()
		LogPath = sLogRoot
	End Property
	Public Property Let LogPath(sPath)
		If sPath <> vbNullString Then
			sLogRoot = sPath
		End If 
	End Property
	Public Property Get LogActive()
		LogActive = bLogActive
	End Property
	Public Property Get LogsToKeep()
		LogsToKeep = iLogToKeep
	End Property
	Public Property Let LogsToKeep(iValue)
	If (VarType(iValue) = vbInteger) Then
		iLogToKeep = iValue
	End If 
	End Property
	Public Property Get LogFile()
		LogFile = sLog
	End Property
	'#---------------------------------------------------------------------------#
	Public Function Start()
		'**********************************************************************************
		' Purpose : Initialize the Log interface, check log path
		'           Easily extend logging into other formats, Ex : Syslog, mail, xml etc.
		' Input   : none
		' Return  : bool	: True|False
		'**********************************************************************************
		Dim currentSub : currentSub = "Class UserLog:Initialize"
		
		If (Helper.CreateFolder(sLogRoot) = -1) Then
			LogEvent ERRORL, ABORT
			WScript.quit
		End If
		
		sLog = sLogRoot & "\" & Helper.GetDayTimeDate() & ".log"
		If (oFso.FileExists(sLog)) Then
			LogEvent INFORMATION, "[" & currentSub & "] The logfile: " & sLog & " allready exists. Appending random number to name of logfile"
			sLog = sLogRoot & "\" & Helper.GetDayTimeDate() & "_" & Helper.Random(9999) & ".log"
		End If
		
		LogEvent INFORMATION, "[" & currentSub & "] Logfile = " & sLog
		
		bLogActive = True
	End Function
	
	Public Sub LogEvent(eventType, sMessage)
		'**********************************************************************************
		' Purpose : Log interface, write various type of events to different formats, 
		'			NT Event, File etc.
		'           Easily extend logging into other formats, Ex : Syslog, mail, xml etc.
		' Input   : i : Event type, Integer 0 = None 1 = Success/Error 2 = Full
		'           sMessage : Log message, String
		'**********************************************************************************
		'Eventlog output
		If EVENTLOG = 1 Or EVENTLOG = 2 Then
			Set oRegEx = New RegExp
			'oRegEx.Pattern = "\[.*\] "
			'Changed to be able to print message file output when Message contains Brackets]
			oRegEx.Pattern = "^(\[[^*\]]*\])+"
			sMessage = oRegEx.Replace (sMessage, "")
			doEventLog eventType, Trim(sMessage)
			Set oRegEx = Nothing
		End If
		
		'Debug EventLog output
		If EVENTLOG = 3 Then
			doEventLog eventType, sMessage
		End If
		
		'Logfile output
		If FILELOG = 1 Or FILELOG = 2 Then
			Set oRegEx = New RegExp
			'oRegEx.Pattern = "\[.*\] "
			'Changed to be able to print message file output when Message contains Brackets]
			oRegEx.Pattern = "^(\[[^*\]]*\])+"
			sMessage = oRegEx.Replace (sMessage, "")
			doFileLog eventType, Trim(sMessage)
			Set oRegEx = Nothing
		End If
		
		'Debug logfile output
		If FILELOG = 3 Then
			doFileLog eventType, sMessage
		End If	
		
		'Debug screen output
		If FILELOG = 3 Or EVENTLOG = 3 Then
			WScript.echo sMessage 
		End If
	End Sub
	
	Private Sub doFileLog(eventType, sMessage)
		'**********************************************************************************
		' Purpose : Write Event to logfile. Build an array of events until path logfile 
		'			is determined.
		'           If logfile can not be written. Events are redirected to eventlog.
		'           EventLog Level 0 = None 1 = Success/Error 2 = Full
		' Input   : eventType : Event type, Integer
		'           0 SUCCESS	1 ERROR (Const ERRORL)	2 WARNING	4 INFORMATION
		'           s : Log message, String
		' Use     : bLog Boolean True|False when actually start logging to file
		'**********************************************************************************
		On Error Resume Next
		Dim currentSub : currentSub = "Class UserLog:FileLog"
		
		'Make sure errorlevel 0
		Err.clear
		
		'Log to file if bLog flag is true
		If bLogActive = True Then
			Set oLog = oFso.OpenTextFile(sLog, FORAPPENDING, True)
			
			If Err.number <> 0 Then
				Helper.EchoErr Err, currentSub
				'Clear error
				Err.clear
				'Check if log folder exists, try to create
				If Helper.CreateFolder(Left(sLog, InStrRev(sLog, "\"))) <> -1 Then
					Set oLog = oFso.OpenTextFile(sLog, FORAPPENDING, True)
					
				Else
					'Abort filelog operation if can't be written, switch to EventLog	
					EVENTLOG = 2
					FILELOG = 0
					Err.Raise = iErr
					LogEvent ERRORL, "[" & currentSub & "] Error occured while writing to logfile: " & sLog & ". The error was: " & Err.description
					LogEvent WARNING, "[" & currentSub & "] Events will permanently be redirected to eventlog. All events occured prior to this warning will now be written."
					
					'Write events from array to eventlog
					If IsArray(aLog) And aLog(0) <> vbNullString Then
						For iArr = 0 To UBound(aLog)
							LogEvent CInt(Left(aLog(iArr), 1)), Right(aLog(iArr), Len(aLog(iArr)) - 1)
						Next
						ReDim aLog(0)	
					End If
					Exit Sub
				End If
			End If
			
			'Write events from array to logfile
			If IsArray(aLog) And aLog(0) <> vbNullString Then
				For iArr = 0 To UBound(aLog)
					oLog.WriteLine Right(aLog(iArr), Len(aLog(iArr)) - 1)
				Next
				ReDim aLog(0)
			End If
			
			Select Case FILELOG
				Case 1
				Select Case eventType
					Case SUCCESS
					oLog.WriteLine Now & " SUCCESS " & sMessage
					Case ERRORL
					oLog.WriteLine Now & " ERROR   " & sMessage
					Case Else
					'Exit Sub 
				End Select
				Case 2
				Select Case eventType
					Case SUCCESS
					oLog.WriteLine Now & " SUCCESS     " & sMessage
					Case ERRORL
					oLog.WriteLine Now & " ERROR       " & sMessage
					Case WARNING
					oLog.WriteLine Now & " WARNING     " & sMessage
					Case INFORMATION
					oLog.WriteLine Now & " INFORMATION " & sMessage
					Case Else
					'Exit Sub
				End Select
				Case 3
				Select Case eventType
					Case SUCCESS
					oLog.WriteLine Now & " SUCCESS     " & sMessage
					Case ERRORL
					oLog.WriteLine Now & " ERROR       " & sMessage
					Case WARNING
					oLog.WriteLine Now & " WARNING     " & sMessage
					Case INFORMATION
					oLog.WriteLine Now & " INFORMATION " & sMessage
					Case Else
					'Exit Sub
				End Select
				Case Else
				Exit Sub
			End Select
			
			oLog.close
			'Set oLog = Nothing
		Else
			'Log to array while path to logfile determined
			If IsArray(aLog) Then
				iArr = UBound(aLog) + 1
				ReDim Preserve aLog(iArr)
			Else
				ReDim aLog(0)
				iArr = UBound(aLog)
			End If
			
			Select Case FILELOG
				Case 1
				Select Case eventType
					Case SUCCESS
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " SUCCESS " & sMessage
					Case ERRORL
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " ERROR   " & sMessage
					Case Else
					ReDim Preserve aLog(iArr-1)
					Exit Sub
				End Select
				Case 2
				Select Case eventType
					Case SUCCESS
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " SUCCESS     " & sMessage
					Case ERRORL
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " ERROR       " & sMessage
					Case WARNING
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " WARNING     " & sMessage
					Case INFORMATION
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " INFORMATION " & sMessage
					Case Else
					Exit Sub
				End Select
				Case 3
				Select Case eventType
					Case SUCCESS
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " SUCCESS     " & sMessage
					Case ERRORL
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " ERROR       " & sMessage
					Case WARNING
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " WARNING     " & sMessage
					Case INFORMATION
					ReDim Preserve aLog(iArr)
					aLog(iArr) = eventType & Now & " INFORMATION " & sMessage
					Case Else
					Exit Sub
				End Select
				Case Else
				Exit Sub
			End Select
		End If
	End Sub
	
	Private Sub doEventLog(eventType, sMessage)
		'********************************************************************************
		' Purpose : Write Event to Eventlog.
		'           EventLog Level 0 = None 1 = Success/Error 2 = Full
		' Input   : eventType : Event type, Integer
		'           0 SUCCESS 1 ERROR (Const ERRORL) 2 WARNING 4 INFORMATION
		'           sMessage : Log message, String
		'********************************************************************************
		Select Case EVENTLOG
			Case 1
			Select Case eventType
				Case SUCCESS
				oShell.LogEvent eventType, sMessage
				Case ERRORL
				oShell.LogEvent eventType, sMessage
				Case Else
				Exit Sub
			End Select
			Case 2
			Select Case eventType
				Case SUCCESS
				oShell.LogEvent eventType, sMessage
				Case ERRORL
				oShell.LogEvent eventType, sMessage
				Case WARNING
				oShell.LogEvent eventType, sMessage
				Case INFORMATION
				oShell.LogEvent eventType, sMessage
				Case Else
				Exit Sub
			End Select
			Case 3
			Select Case i
				Case SUCCESS
				oShell.LogEvent eventType, sMessage
				Case ERRORL
				oShell.LogEvent eventType, sMessage
				Case WARNING
				oShell.LogEvent eventType, sMessage
				Case INFORMATION
				oShell.LogEvent eventType, sMessage
				Case Else
				Exit Sub
			End Select
			Case Else
			Exit Sub
		End Select
	End Sub
	
	Public Sub DelLog()
		'**********************************************************************************
		' Purpose : Delete obsolete logs
		' Input   : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class UserLog:DelLog"
		Dim sProcessTime,tEndTime
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] Log CleanUP Started"
		
		If iLogToKeep <> 0 Then
			LogEvent INFORMATION, "[" & currentSub & "] Call KeepOnlyFiles " & sLogRoot & " " & iLogToKeep
			KeepOnlyFiles sLogRoot, iLogToKeep
		End If
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] Log CleanUP Complete"
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		tEndTime = Timer()
		sProcessTime = ((tEndTime - tStartTime)*1000)
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & APPNAME & " " & APPVERMAJOR &  "." & APPVERMINOR & " ended successfully in " & sProcessTime & " milliseconds"
	End Sub
	
	Private Sub KeepOnlyFiles(sPath, iCount)
		'**********************************************************************************
		' Purpose : Delete obsolete files based upon date.
		'           n newest files are kept.
		' Input   : String (s) Path to root of files
		'           Integer : iCount : Number of folders to keep
		'**********************************************************************************
		On Error Resume Next
		
		Dim cFiles
		Dim currentSub : currentSub = "Class UserLog:KeepOnlyFiles"
		
		Set oFldr = oFso.GetFolder(sPath)
		Helper.EchoErr Err, currentSub
		
		If Err.number <> 0 Then
			LogEvent ERRORL, "[" & currentSub & "] An Error occured connecting to: " & sPath & " old files must be deleted manually."
			Exit Sub
		Else
			LogEvent INFORMATION, "[" & currentSub & "] Connected to: " & sPath
		End If
		
		Set cFiles = oFldr.Files
		Helper.EchoErr Err, currentSub
		
		If Err.number <> 0 Then
			LogEvent ERRORL, "[" & currentSub & "] An Error occured while listing files in folder: " & sPath & ". Old files must be deleted manually."
			Exit Sub
		Else
			LogEvent INFORMATION, "[" & currentSub & "] Succsessfully listed files in folder: " & sPath
		End If
		
		'Check if number of files greater than i
		If cFiles.Count <= iCount Then
			LogEvent INFORMATION, "[" & currentSub & "] Number of file(s) in root is: " & cFiles.Count & ". Number is less or equal to: " & iCount & " wich is the number of file(s) to keep."
			Exit Sub
		End If
		
		LogEvent INFORMATION, "[" & currentSub & "] Number of files in root is: " & cFiles.Count & ". Number is greater: " & iCount & " wich is the number of file(s) to keep."
		
		'ReDim array to number of folders
		ReDim aDate(cFiles.Count -1)
		
		LogEvent INFORMATION, "[" & currentSub & "] Creating array with fixed size: " & cFiles.Count -1 & ". Adding date of folders to array"
		
		iCnt = 0
		
		'Add date creation of all folders to array
		For Each oFile In cFiles
			LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & oFile.DateCreated & " (Path: " & oFile.Path & ")"
			aDate(iCnt) = oFile.DateCreated
			iCnt = iCnt + 1
		Next
		
		'Sorting array by date, ascent sort order (The famous bubble sort)
		LogEvent INFORMATION, "[" & currentSub & "] Sorting dates in array, ascent sort order"
		For n = 0 To UBound(aDate) -1 
			For m = n+1 To UBound(aDate) 
				If aDate(m) < aDate(n) Then
					temp = aDate(m)
					aDate(m) = aDate(n)
					aDate(n) = temp
				End If
			Next
		Next
		
		'Just logging
		LogEvent INFORMATION, "[" & currentSub & "] Array sorted, result in ascent order: "
		For iCnt = 0 To UBound(aDate)
			LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)
		Next
		
		'Cut array, keep (i) rows with date of folders wich is going to be deleted
		ReDim Preserve aDate(UBound(aDate) - iCount)
		LogEvent INFORMATION, "[" & currentSub & "] Array aDate cut, remaing rows are: "
		
		'Even more logging (those debuggers ;))
		For iCnt = 0 To UBound(aDate)
			LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)
		Next
		
		LogEvent INFORMATION, "[" & currentSub & "] Start deleting file(s)..."
		
		For Each oFile In cFiles
			For iCnt = 0 To UBound(aDate)
				If oFile.DateCreated = aDate(iCnt) Then
					LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt) & " matches DateCreated on file: " & oFile.Path & " (Date=" & oFile.DateCreated & ")"
					Helper.DeleteFile oFile.Path
					Exit For
				End If
			Next
		Next
		
		Helper.EchoErr Err, currentSub
		
		If Err.Number = 0 Then
			LogEvent SUCCESS, "[" & currentSub & "] Deleted " & UBound(aDate)+1 & " obsolete log files" 
		End If
	End Sub
End Class

'#################################################################################
' Class Wrapper for Helper. Functions
'#################################################################################
Class HelperClass
	Private oShell,oExec,oFso,oFile,oStdOut,element,cmdOutput
	Private iSize,iInt,iCnt,iWordBreak,iCurrentLenth
	Private sScriptDir, sFilePath, sStreamData, sFolder, sUnc, sResult, sTempFile
	Public aResult
	Private bFound
	'GetDayTimeDate
	Public intSeconds, intMilliseconds
	'KeepOnly
	Public cCollection, oObject, sType, aDate, oFldr, n, m, temp, iCnt2, aDeleted()
	'GetFolderContent
	Private folder, items, item, FolderExists2, sType2, arrList(),i,sName
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		Set oFso		= CreateObject("Scripting.FileSystemObject")
		Set oShell		= CreateObject("Wscript.Shell")
	End Sub
	
	Private Sub Class_Terminate
		Set oFso		= Nothing
		Set oShell		= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	
	Function EchoErr(myError, sProcedure)
		'**********************************************************************************
		' Purpose : Verify and Post Err message
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:EchoErr"
		
		If Err.Number <> 0 Then
			WScript.echo "["& sProcedure & "] ERROR: Number:" & Err.Number & " : " & Err.Description
			UserLog.LogEvent ERRORL, "["& sProcedure & "] ERROR: Number:" &Err.Number & " : " & Err.Description
		End If
	End Function
	
	Sub Import (sFileName)
		'**********************************************************************************
		' Purpose : Import external file
		'**********************************************************************************
		sScriptDir = oFso.GetParentFolderName(WScript.ScriptFullName)   
		sFilePath = oFso.BuildPath(sScriptDir,sFileName)   
		Const ForReading = 1   
		
		Set oFile = oFso.OpenTextFile(sFilePath,ForReading)   
		sStreamData = oFile.ReadAll()   
		ExecuteGlobal sStreamData   
	End Sub
	
	Public Function ShellRun(sCmd, iWinStyle, bWait)
		'**********************************************************************************
		' Purpose : Execute a command, It will then execute the command in a shell, 
		'           and capture the output into a file. That file is then read in and its 
		'           contents are returned as an Array() in the value the function returns.
		' Inputs : String : sCmd : The command to execute
		'		   Integer: iWinStyle : the window style (check VBS help for values)
		'		   Bool   : bWait : Wait for execution complete and return the output
		' Output : Array  : ShellRun : the actual output if any
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:ShellRun"
				
		sTempFile = GetTempFilename()
		On Error Resume Next 
		
		Dim sCmdOnly
		Dim sCmdPath
		Dim sCmdDrive
		Dim COMSPEC : COMSPEC = "%comspec% /c "
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Command is : ["  & sCmd  & "]"
		
		'Build the %comspec% to set drive and work directory
		If InStr(sCmd,Chr(34)) = 1 Then 'command is quoted
			sCmdOnly = Left(sCmd, InStr(2,sCmd,Chr(34)))
			sCmdOnly = Replace(sCmdOnly,Chr(34),vbNullString)
		Else
			sCmdOnly = Left(sCmd, InStr(2,sCmd,Chr(32)))
			sCmdOnly = Replace(sCmdOnly,Chr(32),vbNullString)
		End If 	
		
		If InStr(sCmdOnly,":") = 2 Then 
			'extract drive info
			sCmdDrive = Left(sCmdOnly, InStr(sCmdOnly,":"))
			COMSPEC = COMSPEC & sCmdDrive & " " & chr(38) & " "
			'extract Path info
			sCmdpath = Left(sCmdOnly, InStrRev(sCmdOnly,"\")-1)
			If InStr(sCmdPath,Chr(32)) > 0 Then
				sCmdPath = Chr(34) & sCmdPath & Chr(34)
			End if
			COMSPEC = COMSPEC & "cd " & sCmdPath & " " & chr(38) & " "
		End If 
				
		If bWait Then
			oShell.Run COMSPEC &  sCmd  & " > " & sTempFile, iWinStyle, true
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Command Execute (Wait): [" & COMSPEC & sCmd  & " > " & sTempFile & "]"
			If Helper.FileExists(sTempFile,False) Then
				cmdOutput = Split(oFso.OpenTextFile(sTempFile,1).ReadAll,vbCRLF)
				If Err.Number = 62 Then
					UserLog.LogEvent WARNING, "[" & currentSub & "] No Output result from Command Execute"
					'Clear error
					Err.Clear
				Else
					'Just Debug
					UserLog.LogEvent SUCCESS, "[" & currentSub & "] Found Output result from Command Execute."
					'For iCnt = 0 To UBound(cmdOutput)
					'	UserLog.LogEvent INFORMATION, "[" & currentSub & "] -" & cmdOutput(iCnt)
					'Next
				End If
	
				oFso.DeleteFile sTempFile, true
			Else
				UserLog.LogEvent WARNING, "[" & currentSub & "] No Output File from Command Execute"
			End If  
			ShellRun = cmdOutput
		Else 
			oShell.Run COMSPEC & sCmd, iWinStyle, false
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Command Execute (No Wait): [" & COMSPEC & sCmd 
			ShellRun = Array()
		End If 
			
		If Err.Number <> 0 Then
			Helper.EchoErr Err, currentSub
			'Clear error
			Err.clear
		End If
	End Function

	Public Function ShellExec(sCmd, bWait)
		'**********************************************************************************
		' Purpose : Execute a command
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:ShellExec"
				
		If (Not IsNothing(oShell)) then
			Set oExec = oShell.exec ("%comspec% /c " & Chr(34) & sCmd & Chr(34))
		
			If (bWait) then
				'Looping allowing it to finish
				Do Until oExec.Status = "1"
					wscript.sleep 100
				Loop
				
				'Create sdtout object for redirect of output from sCmd
		  		Set oStdOut = oExec.StdOut
				
				'Grabbing output from sCmd
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Redirecting output from : " & sCmd
				While Not oStdOut.AtEndOfStream
	 				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Output : " & oStdOut.ReadLine
				Wend
			End If 

			If oExec.ExitCode <> 0 Then
			     	UserLog.LogEvent WARNING, "[" & currentSub & "] Warning: Non-zero exit code"
			End If
			
			'Return the exit code
			ShellExec = oExec.ExitCode

			On Error Goto 0
			If Err.Number <> 0 Then
					Helper.EchoErr Err, currentSub
					'Clear error
					Err.clear
			End If
		End If 
	End Function

	Public Function Validate(sStringToTest,aArray)
		'#--------------------------------------------------------------------------------#
		' Purpose : Check if the element is part of an array
		'#--------------------------------------------------------------------------------#	
		bFound = False
		
		If (IsArray(aArray)) Then
			For Each Element In aArray				
				If LCase(sStringToTest) = LCase(Element) Then
					bFound = True
					Exit For
				End If
			Next 
		End If
		Validate = bFound
	End Function 
	
	Public Function ValidateVFS(ByVal sStringToTest,aArray)
		'#--------------------------------------------------------------------------------#
		' Purpose : Check if the element is part of an array
		'#--------------------------------------------------------------------------------#	
		bFound = False
		Dim vfselement
		
		'Testing root 
		If sStringToTest = vbNullString  Then
			sStringToTest = "//"
		Else
			sStringToTest = sStringToTest & "/"
		End If

		If (IsArray(aArray)) Then
			For Each vfselement In aArray
				vfselement = vfselement & "/"
				If InStr(Left(LCase(sStringToTest),Len(vfselement)),LCase(vfselement)) Then
					bFound = True
					Exit For
				End If
			Next 
		End If
		ValidateVFS = bFound
	End Function 
	
	'#--------------------------------------------------------------------------------#	
	' Function: FileMatchesPattern(strFileName, strWildCard) 
	'#--------------------------------------------------------------------------------#	
	' Function to test if a filename matches the wildcard characters passed. 
	' Converts a wildard (*.vbs) to a valid regular expression so that the file name can be tested  
	' for a match using a regular expression object.  This negates the need to perform a lot of  
	' string parsing and comparison. 
	' Params:	strFileName	String, Holding the name of the file to test (must not include the path) 
	' 			strWildCard	String, Holding the wildcard string used to compare the file with. (eg. "*.vbs") 
	' Returns:	True if the filename matches the wildcard, otherwise False. 
	'#--------------------------------------------------------------------------------#	
	Public Function FileMatchesPattern(strFileName, strWildCard) 
	  
	        Dim objRegExp, strPattern 
	        Set objRegExp = CreateObject("VBScript.RegExp") 
	         
	        ' Update the wildcard string to define a valid regular expression 
	        strPattern = Replace(strWildCard, "\", "\\")
	        strPattern = Replace(strPattern, ".", "\.") 
	        strPattern = Replace(strPattern, "[", "\[") 
	        strPattern = Replace(strPattern, "]", "\]") 
	        strPattern = Replace(strPattern, "*", ".*") 
	        'strPattern = Replace(strPattern, "*", ".*")
		     strPattern = "^" & strPattern & "$" 
	         
	        With objRegExp 
	                .Pattern = strPattern 
	                .IgnoreCase = True 
	                .Global = True 
	        End With 
	         
	        FileMatchesPattern = objRegExp.Test(strFileName) 
	        Set objRegExp = Nothing 
	End Function 

	Public Function GetSize(varArray)
		'#--------------------------------------------------------------------------------#
		' Purpose : Check the array size
		'#--------------------------------------------------------------------------------#	
		iSize = 0
		
		On Error Resume Next
		iSize = UBound(varArray)
		If Err.Number Then
			If Err.Number = 9 Then
				iSize = 0
			End If
		Else
			iSize = UBound(varArray) + 1
		End If
		GetSize = iSize
	End Function 
	
	Public Function  IsNothing (Obj)
		'#--------------------------------------------------------------------------------#
		' Purpose : Check if object is Nothing
		'#--------------------------------------------------------------------------------#	
		If TypeName(Obj) = "Nothing" Then
			IsNothing = True
		Else
			IsNothing = False
		End If
	End Function
	
	Function FileExists(sFilePath, bRequired)
		'**********************************************************************************
		' Purpose : Verify presense of a file, abort the script if the file is not present
		'		    and it's required.
		' Input   : string	: sFilePath 		: Path to file
		'           bool	: bRequired	: True|False
		' Return  : bool	: True|False
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FileExists"
		
		If (oFso.FileExists(sFilePath)) Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] The file: " & sFilePath & " is present."
			FileExists = True
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] The file: " & sFilePath & " does not exist."
			FileExists = False
		End If
		
		If bRequired And FileExists = False Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The file: " & sFilePath & " is required for futher processing of this script."
			Helper.Terminate
		End If
	End Function
	
	Function FolderExists(sFolderPath, bRequired)
		'**********************************************************************************
		' Purpose : Verify presense of a folder, abort the script if the folder is not present
		'		    and it's required.
		' Input   : string	: sFFolderPath 		: Path to folder
		'           bool	: bRequired	: True|False
		' Return  : bool	: True|False
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:FolderExistsExists"
		
		If (oFso.FolderExists(sFolderPath)) Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] The Folder: " & sFolderPath & " is present."
			FolderExists = True
		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The Folder: " & sFolderPath & " does not exist."
			FolderExists = False
		End If
		
		If bRequired And FolderExists = False Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The folder: " & sFolderPath & " is required for futher processing of this script."
			Helper.Terminate
		End If
	End Function
	
	Function GetFolderContent(sFolderPath, bType, sMask)
		'**********************************************************************************
		' Purpose : Gets the content of a folder, abort the script if the folder is not present
		'		    and it's required.
		' Input   : string	: sFolderPath 		: Path to folder
		'			bool	: bType False:Files | True:Folder
		' Return  : Array	: Array of file/folder Names
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:GetFolderContent"
		
		If (oFso.FolderExists(sFolderPath)) Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] The Folder: " & sFolderPath & " is present."
			
			Set folder = oFso.GetFolder(sFolderPath)
			
			Select Case bType
				Case True
					sType2 = "Folder"
					Set items = folder.SubFolders
				Case False
					sType2 = "File"
					Set items = folder.Files
			End Select
			
			If items.count > 0 then
				i=0
				For each item In items
					If Helper.FileMatchesPattern (item.Name, sMask) then
						UserLog.LogEvent INFORMATION, "[" & currentSub & "] Listing " & sType2 & ": " & item.Name
						ReDim Preserve arrList(i)
						arrList(i) = item.Name
						i = i + 1
					End if
				Next
			End If 
			GetFolderContent = arrList

		Else
			UserLog.LogEvent ERRORL, "[" & currentSub & "] The Folder: " & sFolderPath & " does not exist."
			Set GetFolderContent = Array()
		End If
	End Function
	
	Public Function GetTempFilename()
		'**********************************************************************************
		' Purpose : Generate e temporary file, 
		' Inputs : None
		' Output : StringArray  : ShellRun : the actual output if any
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:GetTempFilename"
		
		GetTempFilename = oShell.ExpandEnvironmentStrings("%temp%") & oFso.GetTempName
	End Function	
		
	Function CreateFolder(sPath)
		'**********************************************************************************
		' Purpose : Create a folder
		' Input   : string	: sPath	: Path to folder
		' Return  : integer	:  -1 : folder creation error
		'						0 : folder allready exists
		'						1 : folder successfully created
		'**********************************************************************************
		sFolder = vbnullString
		
		Dim currentSub : currentSub = "Class Helpers:CreateFolder"
		
		On Error Resume Next
		
		'Add missing \ if required
		If Right(sPath, 1) <> "\" Then
			sPath = sPath & "\"
		End If
		
		'Check if path is UNC replace base path \\server.fqdn\something with "\"
		If Left(sPath, 2) = "\\" Then
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] UNC Path: " & sPath
			sUNC = sPath
			Set oRegEx = New RegExp
			oRegEx.Pattern = "\\\\[A-Za-z0-9.]+\\\w+\$?\\"
			sResult = oRegEx.Replace (sPath, "")
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] UNC stripped, result: " & sResult
			sUnc = Left(sPath, Len(sPath) - Len(sResult))
			sFolder = sUnc
		End If
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Start creating directory structure: " & sPath
		
		CreateFolder = 0
		
		'Check and create the folder tree
		Do Until sFolder = sPath
			sFolder = Left(sPath, InStr(Len(sFolder) + 1, sPath, "\"))
			'UserLog.LogEvent INFORMATION, "[" & currentSub & "] Checking if folder exists: " & sFolder
			If Not oFso.FolderExists(sFolder) Then
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating folder: " & sFolder
				ofso.CreateFolder(sFolder)
				If Err.number <> 0 Then
					UserLog.LogEvent ERRORL, "[" & currentSub & "] Error creating: " & sFolder & ". The error was: " & Err.description
					CreateFolder = False
					Exit Function
				Else 
					CreateFolder = true
				End If
			End If
		Loop
	End Function

	Function DeleteFile(sPath)
		'**********************************************************************************
		' Purpose : Delete file
		' Input   : String : sPath : path to file
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:DeleteFile"
		
		On Error Resume Next
		Err.clear
		
		oFso.DeleteFile sPath, True
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to delete File: " & sPath & ". The error was: " & Err.description & " (" & Err.number & ")"
			DeleteFile = False
		Else
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] File: " & sPath & " was successfully deleted."
			DeleteFile = True 
		End If
	End Function
	
	Function DeleteFolder(sPath)
		'**********************************************************************************
		' Purpose : Delete folder
		' Input   : String : sPath : path to folder
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:DeleteFolder"
		
		On Error Resume Next
		Err.clear
		
		oFso.DeleteFolder sPath, True
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to delete Folder: " & sPath & ". The error was: " & Err.description & " (" & Err.number & ")"
			DeleteFolder = False 
		Else
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Folder: " & sPath & " was successfully deleted."
			DeleteFolder = True
		End If
	End Function
	
	Function GetDayTimeDate()
		'**********************************************************************************
		' Purpose : Get Day,Date,Time
		' Input   : None
		' Return  : Current day of week + Date + Time
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:GetDayTimeDate"
		
		GetDayTimeDate = WeekdayName(Weekday(Now, vbUseSystemDayOfWeek),,vbUseSystemDayOfWeek) & " " & Date & " "
		
		intSeconds = (Hour(Now) * 3600) + (Minute(Now) * 60) + Second(Now) 
        intMilliseconds = Timer() - intSeconds 
        'intMilliseconds = Fix(intMilliseconds * 100) 
        intMilliseconds = Fix(intMilliseconds * 10000) 
		
		If CInt(Hour(Now)) < 10 Then
			GetDayTimeDate = GetDayTimeDate & "0" & Hour(Now) & "."
		Else
			GetDayTimeDate = GetDayTimeDate & Hour(Now) & "."
		End If
		
		If CInt(Minute(Now)) < 10 Then
			GetDayTimeDate = GetDayTimeDate & "0" & Minute(Now) & "."
		Else
			GetDayTimeDate = GetDayTimeDate & Minute(Now) & "."
		End If
		
		If CInt(Second(Now)) < 10 Then
			GetDayTimeDate = GetDayTimeDate & "0" & Second(Now)
		Else
			GetDayTimeDate = GetDayTimeDate & Second(Now)
		End If
		
		If InStr(GetDayTimeDate, "/") Then
			GetDayTimeDate = Replace(GetDayTimeDate, "/", ".")
		End If
		If InStr(GetDayTimeDate, "\") Then
			GetDayTimeDate = Replace(GetDayTimeDate, "\", ".")
		End If
		
		GetDayTimeDate = GetDayTimeDate & "_" & intMilliseconds
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating Date " & GetDayTimeDate
	End Function
	
	Function Random(iValue)
		'**********************************************************************************
		' Purpose : Create a random integer between 0 and i
		' Input   : integer		: iValue	: The max value
		' Return  : integer		: Random number between 0 and Input (i)
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:Random"
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating a random integer between: 0-" & iValue
		
		'Generate seed
		Randomize
		iInt = Int(iValue * Rnd)
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Random integer is: " & iInt
		Random = iInt
	End Function
	
	Sub Terminate()
		'**********************************************************************************
		' Puropose : Terminate the script, moving log to error directory.
		'            Inform the user about the error.
		' Input    : None
		'**********************************************************************************
		Dim currentSub : currentSub = "Class Helper:Terminate"
		
		UserLog.LogEvent ERRORL, "[" & currentSub & "] Script Aborted"
		UserLog.LogEvent SUCCESS, "'#--------------------------------------------------------------------------------#"
		WScript.quit
	End Sub
	
	Function BreakString (str, str2, length, fillSpaces) 
		'********************************************************************************
		' Purpose	: Break up a string into multiline string having a given length
		' Input   	: string	: str		: the input string
		'			  string	: str2		: the input string to append at the end
		'			  integer	: length	: the desired final length
		' 			  bool		: fillSpaces: option to fill spaces
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:BreakString"
		
		'fill with spaces
		ReDim aResult(0)
		
		iCnt = 0
		'process the main string
		While (Len(str) >length) 
			iWordBreak = InStrRev(str, " ", length)
			'force a break if no word break detected
			If (iWordBreak = 0) Then
				iWordBreak = length
			End If
			ReDim Preserve aResult(iCnt)
			aResult(iCnt) = Left(str, iWordBreak)
			str = Right(str,Len(str)-iWordBreak)
			iCnt = iCnt + 1
		Wend
		'check if the remaining string can accept the append of str2
		If (Len(str)+Len(str2)+1 >length) Then
			ReDim Preserve aResult(iCnt)
			aResult(iCnt) = str
			If (Len(Trim(str2))> 0) Then
				ReDim Preserve aResult(iCnt+1)
				If fillSpaces Then
					aResult(iCnt+1) = Space(length - Len(str2)) & str2
				Else
					aResult(iCnt+1) = str2
				End If
			End If
		Else
			ReDim Preserve aResult(iCnt)
			If fillSpaces Then
				aResult(iCnt) = str & Space(length - Len(str)- Len(str2)) & str2
			Else
				If (Len(str2) > 0) Then
					aResult(iCnt) = str & Space(1) & str2
				Else	
					aResult(iCnt) = str
				End If
			End If
		End If
		BreakString = aResult
	End Function
	
	Function BuildString (str, length)
		'********************************************************************************
		' Purpose : fill up a string with space to a given length
		' Input   : string	: str		: the input string
		'			integer : length	: the desired final length
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:BuildString"
		
		'fill with spaces
		iCurrentLenth = Len(str)
		str = str & Space(length - iCurrentLenth)
		
		buildString = str
	End Function
	
	Function BuildStringNumber (str, length, fillChar, endchar)
		'********************************************************************************
		' Purpose : fill up a string with FillChar to a given length
		' Input   : string	: str		: the input string
		'			integer : length	: the desired final length
		'			string  : fillChar	: the desired Filling Character
		'			string  : endchar	: the desired End Character
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:BuildStringNumber"
		
		'fill with spaces
		iCurrentLenth = Len(str)
		BuildStringNumber = String(length - iCurrentLenth, fillChar) & str & endChar

	End Function
	
	Function CleanString (str)
		'********************************************************************************
		' Purpose : clean any leading/trailing spaces and %20 caracters
		' Input   : string	: str		: the input string
		' Output  : string  : the cleaned string
		'********************************************************************************
		Dim currentSub : currentSub = "Class Helpers:CleanString"
		
		'Trim with spaces
			str = Trim(str)
		'clear %20
			str = Replace(str,"%20"," ")
		
		CleanString = str
	End Function
	
	Function GetTimeStamp() 
        Dim intSeconds, intMilliseconds, strMilliseconds, intDatePart, intTimePart 
         
        intSeconds = (Hour(Now) * 3600) + (Minute(Now) * 60) + Second(Now) 
        intMilliseconds = Timer() - intSeconds 
        intMilliseconds = Fix(intMilliseconds * 100) 
         
        intDatePart = (Year(Now) * 10000) + (Month(Now) * 100) + Day(Now) 
        intTimePart = (Hour(Now) * 1000000) + (Minute(Now) * 10000) + (Second(Now) * 100) + intMilliseconds 
         
        getTimeStamp = intDatePart & " " & intTimePart  
	End Function 

	Function KeepOnly (sPath, iCount, iType)
		'**********************************************************************************
		' Purpose : Delete obsolete folders based upon creation date.
		'           n newest files are kept.
		' Input   : String (s) Path to root of folders
		'           Integer : iCount : Number of folders to keep
		'			Integer	: iType : 0 Files
		'							  1 Folders
		'							  2 Junctions
		'**********************************************************************************
		'On Error Resume Next
		On Error GoTo 0
		
		Dim currentSub : currentSub = "Class Helper:KeepOnly"
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] CleanUP Started"
		
		Set oFldr = oFso.GetFolder(sPath)
		Helper.EchoErr Err, currentSub
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] An Error occured connecting to: " & sPath 
			KeepOnly = vbNull
			Exit function
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Connected to: " & sPath
		End If
		
		'Switch Folder or file Mode
		Select Case (iType)
			Case 0
				sType = "File"
				Set cCollection = oFldr.Files
				Helper.EchoErr Err, currentSub
			Case 1
				sType = "Folder"
				Set cCollection = oFldr.SubFolders
				Helper.EchoErr Err, currentSub
			Case  2
				sType = "Junction"
				Set cCollection = oFldr.SubFolders
				Helper.EchoErr Err, currentSub
		End Select
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] An Error occured while listing " & sType & " in folder: " & sPath & ". Old " & sType & " must be deleted manually."
			KeepOnly = vbNull 
			Exit function
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] Succsessfully listed " & sType & " in folder: " & sPath
		End If
		
		'Check if number of files greater than i
		If cCollection.Count <= iCount Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Number of " & sType & " in root is: " & cCollection.Count & ". Number is less or equal to: " & iCount & " wich is the number of " & sType & " to keep."
			KeepOnly = vbNull 
			Exit function
		End If
		
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] Number of " & sType & " in root is: " & cCollection.Count & ". Number is greater: " & iCount & " which is the number of " & sType & " to keep."
		
		'ReDim array to number of folders
		ReDim aDate(cCollection.Count -1)
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Creating array with fixed size: " & cCollection.Count -1 & ". Adding date of " & sType & " to array"
		
		iCnt = 0
		
		'Add date creation of all objects to array
		For Each oObject In cCollection
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & oObject.DateCreated & " (Path: " & oObject.Path & ")"
			aDate(iCnt) = Array(oObject.DateCreated,oObject)
			iCnt = iCnt + 1
		Next
		
		'Sorting array by date, ascent sort order (The famous bubble sort)
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Sorting dates in array, ascent sort order"
		For n = 0 To UBound(aDate) -1 
			For m = n+1 To UBound(aDate) 
				If aDate(m)(0) < aDate(n)(0) Then
					temp = aDate(m)
					aDate(m) = aDate(n)
					aDate(n) = temp
				End If
			Next
		Next
		
		'Just logging
'		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Array sorted, result in ascent order: "
'		For iCnt = 0 To UBound(aDate)
'			UserLog.LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)(0) & " (Path: " & aDate(iCnt)(1).Path & ")"
'		Next
		
		'Cut array, keep (i) rows with date of folders wich is going to be deleted
		ReDim Preserve aDate(UBound(aDate) - iCount)
		ReDim aDeleted (UBound(aDate))
'		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Array aDate cut, remaing rows are: "
		
		'Even more logging (those debuggers ;))
'		For iCnt = 0 To UBound(aDate)
'			UserLog.LogEvent INFORMATION, "[" & currentSub & "] aDate(" & iCnt & ") = " & aDate(iCnt)(0) & " (Path: " & aDate(iCnt)(1).Path & ")"
'		Next
		
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Start deleting " & sType & "..."
		For iCnt2 = 0 To UBound(aDate)
			aDeleted (iCnt2)	= aDate(iCnt2)(1).Name
			Select Case (sType)
				Case "File"
					Helper.DeleteFile aDate(iCnt2)(1).Path
				Case "Folder"
					Helper.DeleteFolder aDate(iCnt2)(1).Path
				Case "Junction"
					Junction.DeleteJunction aDate(iCnt2)(1).ParentFolder.Path , aDate(iCnt2)(1).Name
			End Select
		Next
		
		Helper.EchoErr Err, currentSub
		
		If Err.Number = 0 Then
			UserLog.LogEvent SUCCESS, "[" & currentSub & "] Deleted " & UBound(aDate)+1 & " obsolete " & sType & " Entries." 
		End If
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] CleanUP Complete"
		KeepOnly = aDeleted
	End function
End Class

'#################################################################################
' Class Wrapper for RaidenFTPD Command Output File
'#################################################################################
Class RaidenOutFileClass
	'local vars
	Private sUserFile
	Private	oFile,oFso,oOut
	Private	sStr, sLine, sTmpStr  	
	Private ilength,iStrLength,ilenth1,ilenth2
	Private aMultiLineMsg
	'class vars
	Private c_sServer, c_sDestUser, c_iWidth, c_bSceneView, c_bOutputResult, c_sFilePath, c_sGCID, c_sCmdType
	'#---------------------------------------------------------------------------#
	Private Sub Class_Initialize
		c_bOutputResult	= True
		c_bSceneView	= True
		c_sFilePath 	= vbNullString
		c_sGCID 		= vbNullString
		c_sServer 		= vbNullString
		c_sDestUser		= vbNullString
		c_sCmdType		= "SiteCommand"
		c_iWidth		= 71
		Set oFile		= Nothing
		Set oOut		= Nothing
		Set oFso		= CreateObject("Scripting.FileSystemObject")
	End Sub
	Private Sub Class_Terminate
		Set oFso	= Nothing
		Set oFile	= Nothing
		Set oOut	= Nothing
	End Sub
	'#---------------------------------------------------------------------------#
	Public Property Get Path()
		Path = c_sFilePath
	End Property
	Public Property Let Path(sPath)
		If sPath <> vbNullString Then
			c_sFilePath = sPath
		End If 
	End Property
	Public Property Get Width()
		Width = c_iWidth
	End Property
	Public Property Let Width(iWidth)
		c_iWidth = iWidth
	End Property
	Public Property Get SceneView()
		SceneView = c_bSceneView
	End Property
	Public Property Let SceneView(bSceneView)
		c_bSceneView = bSceneView
	End Property
	Public Property Get Result()
		Result = c_bOutputResult
	End Property
	Public Property Get UserFile()
		UserFile = sUserFile
	End Property
	Public Property Let Result(bOutputResult)
		If TypeName(bOutputResult) = vbBoolean Then
			c_bOutputResult = bOutputResult
		End If 
	End Property
	Public Property Get GCID()
		GCID = c_sGCID
	End Property
	Public Property Let GCID(sGCID)
		If sGCID <> vbNullString Then
			c_sGCID = sGCID
		End If 
	End Property
	Public Property Get Server()
		Server = c_sServer
	End Property
	Public Property Let Server(sServer)
		If (VarType(sServer) = vbString) Then
			c_sServer = sServer
		End If 
	End Property
	Public Property Get DestUser()
		DestUser = c_sDestUser
	End Property
	Public Property Let DestUser(sDestUser)
		If (VarType(sDestUser) = vbString) Then
			c_sDestUser = sDestUser
		End If 
	End Property
	Public Property Get CmdType()
		CmdType = c_sCmdType
	End Property
	Public Property Let CmdType(sCmdType)
		If sCmdType <> vbNullString Then
			c_sCmdType = sCmdType
			Set oOut = Nothing
		End If 
	End Property	
	'#---------------------------------------------------------------------------#
	
	Public Sub Initialize()
		'********************************************************************************
		' Purpose : Create an FTPD reply (Output file) as an object oOut
		' Input   : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:Initialize"
		
		'On Error Resume Next
		Err.clear
		
		If (LCase(CmdType) = "userlogin" Or  LCase(CmdType) = "sitecommand") Then
			sUserFile = c_sFilePath & "\OutPut" & "\ask-on" & c_sCmdType & "." & c_sGCID
		Else 
			If LCase(CmdType) = "notify" Then
				sUserFile = Path & "\Message" & "\site-Message-" & Server & "-" & DestUser & ".msg"
			End If
		End If 
		
		Set oOut = oFso.CreateTextFile(sUserFile, True)
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to create output: " & UserFile & ". The error was : " & Err.description & " (" & Err.number & ")"
			Helper.Terminate
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & UserFile & " was successfully created."
		End If
	End Sub	
	
	Sub WriteResultOnly()
		'********************************************************************************
		' Puropose : Write the common intro of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteResultOnly"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If (c_bOutputResult = True) Then 
			oOut.WriteLine "1"
		Else 
			oOut.WriteLine "0"
		End If
		
		Close
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Result : " & c_bOutputResult
	End Sub
	
	Sub WriteMsgHeader()
		'********************************************************************************
		' Puropose : Write the common intro of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgHeader"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If (c_bOutputResult = True) Then 
			oOut.WriteLine "1"
		Else 
			oOut.WriteLine "0"
		End If
		
		If c_bSceneView Then
			sStr = SCENEHEADER
		Else
			sStr = NORMALHEADER
		End If
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Header."
	End Sub
	
	Sub WriteMsgHeaderNoResult()
		'********************************************************************************
		' Puropose : Write the common intro of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgHeaderNoResult"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			sStr = SCENEHEADER
		Else
			sStr = NORMALHEADER
		End If
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Header No Result."
	End Sub
	
	Sub WriteMsgSeperator()
		'********************************************************************************
		' Purpose : Build up a Formated Seperator string
		' Input   : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgSeperator"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 	
		
		If c_bSceneView Then
			sStr = SCENESEPARATOR
		Else
			sStr = NORMALSEPARATOR
		End If
		If (sStr <> vbNullString) Then
			oOut.WriteLine sStr
		End If
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Seperator"
	End Sub
	
	Sub WriteMsgTail()
		'********************************************************************************
		' Puropose : Write the common last lines of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgTail"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			sStr = SCENETAIL
		Else
			sStr = NORMALTAIL
		End If
		If (sStr <> vbNullString) Then
			oOut.Write sStr
		End If

		Close
		UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message Tail"
	End Sub
	
	Sub Close()
		'********************************************************************************
		' Puropose : Write the common last lines of every user reply
		' Input    : None
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:Close"
		
		oOut.Close
		
		If Err.number <> 0 Then
			UserLog.LogEvent ERRORL, "[" & currentSub & "] Failed to close output: " & UserFile & ". The error was : " & Err.description & " (" & Err.number & ")"
			Helper.Terminate
		Else
			UserLog.LogEvent INFORMATION, "[" & currentSub & "] File: " & UserFile & " was successfully Closed."
		End If
		
		Set oOut = Nothing
	End Sub
	
	Sub WriteMsg (sMessage, iPreSpace)
		'********************************************************************************
		' Purpose : Build and Write a Formated string
		' Input   : string  : sMessage	    : the input string
		'			integer : preSpace	: the desired pre spaces to insert
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsg"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			aMultiLineMsg = Helper.BreakString(sMessage,vbNullString,c_iWidth - iPreSpace - 3,True)
			For Each sLine In aMultiLineMsg
				sTmpStr = "|" & Space(iPreSpace) & sLine
				sTmpStr = Helper.BuildString(sTmpStr,(c_iWidth-1)) & "|"
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		Else
			aMultiLineMsg = Helper.BreakString(sMessage,vbNullString,c_iWidth - iPreSpace + 1,False)
			For Each sLine In aMultiLineMsg
				sTmpStr = Space(iPreSpace) & sLine
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		End If
	End Sub
	
	Sub WriteMsgWithAppend (sMessage, sMessage2, iPreSpace)
		'********************************************************************************
		' Purpose : Build and write a Formated string
		' Input   : string  : sMessage	    : the input string
		'			string  : sMessage2		: the string to append
		'			integer : iPreSpace	: the desired pre spaces to insert
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:WriteMsgWithAppend"
		
		If Helper.IsNothing(oOut) Then 
			Initialize
		End If 
		
		If c_bSceneView Then
			aMultiLineMsg = Helper.BreakString(sMessage,sMessage2,c_iWidth - iPreSpace - 3,True)
			For Each sLine In aMultiLineMsg
				sTmpStr = "|" & Space(iPreSpace) & sLine
				sTmpStr = Helper.BuildString(sTmpStr,(c_iWidth-1)) & "|"
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		Else
			aMultiLineMsg = Helper.BreakString(sMessage,sMessage2,c_iWidth - iPreSpace + 1,False)
			For Each sLine In aMultiLineMsg
				sTmpStr = Space(iPreSpace) & sLine
				oOut.WriteLine sTmpStr
				UserLog.LogEvent INFORMATION, "[" & currentSub & "] Write Message : " & sTmpStr
			Next
		End If
	End Sub
	
	Sub PostMessage(sHeader,sMessage,iPreSpace)
		'********************************************************************************
		' Purpose : Poste a full message to the User
		' Input   : string  : sHeader	    : the Msg Header
		'			string  : sMessage		: the Message
		'			integer : iPreSpace		: the desired pre spaces to insert
		'********************************************************************************
		Dim currentSub : currentSub = "Class RaidenOutFile:PostMessage"
		
		WriteMsgHeader
		WriteMsg sHeader,iPreSpace
		WriteMsgSeperator 
		WriteMsg sMessage,iPreSpace	
		WriteMsgTail
			
		UserLog.LogEvent SUCCESS, "[" & currentSub & "] " & "Posted Message: " & sMessage
	End Sub
End Class

Public Sub Class_Event(sSource, sEventType,ByVal bResult,ByVal values)
	'********************************************************************************
	' Purpose : Fire an event received from the child objects
	'********************************************************************************
	Dim currentSub : currentSub = "Main:Class_Event"
	
	If IsArray(values) Then
		values = Join(values,"|")
	ElseIf (values = vbNullString) Then
		values = "Null"
	End If 
	
	If (TypeName(DEBUG_CLASS_EVENTS) <> "Nothing") Then
		If (DEBUG_CLASS_EVENTS = True) Then
			WScript.Echo "EVENT FIRED [" & currentSub & "] source: " & sSource & " ; EventType:" & sEventType & " ; Result:" & bResult & " ; values:" & values
		End If
	End If 
End Sub

Sub Import (sFileName)
	'**********************************************************************************
	' Purpose : Import external file
	'**********************************************************************************
	Dim oFso, oFile
	Dim sScriptDir, sFilePath, sStreamData
	
	Set oFso		= CreateObject("Scripting.FileSystemObject")
	sScriptDir = oFso.GetParentFolderName(WScript.ScriptFullName)   
	sFilePath = oFso.BuildPath(sScriptDir,sFileName)   
	Const ForReading = 1   
	
	Set oFile = oFso.OpenTextFile(sFilePath,ForReading)   
	sStreamData = oFile.ReadAll()   
	ExecuteGlobal sStreamData   
End Sub